<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class BenefitsExport implements FromCollection, WithHeadings, WithMapping, WithStyles, ShouldAutoSize
{
    protected $benefits;

    public function __construct($benefits)
    {
        $this->benefits = $benefits;
    }

    public function collection()
    {
        return $this->benefits;
    }

    public function headings(): array
    {
        return [
            '#',
            'Employee',
            'Type',
            'Employee Share',
            'Employer Share',
        ];
    }

    public function map($benefit): array
    {
        static $i = 0;
        $i++;

        return [
            $i,
            $benefit->payroll->employee->last_name . ', ' . $benefit->payroll->employee->first_name,
            $benefit->type,
            (float) $benefit->employee_share ?? 0,
            (float) $benefit->employer_share ?? 0,
        ];
    }


    public function styles(Worksheet $sheet)
    {
        // Header styling
        $sheet->getStyle('A1:E1')->applyFromArray([
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
            ],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => '4F81BD'], // soft blue
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
                'vertical' => Alignment::VERTICAL_CENTER,
            ],
        ]);

        // Number alignment
        $lastRow = $sheet->getHighestRow();
        $sheet->getStyle("D2:E{$lastRow}")
            ->getAlignment()
            ->setHorizontal(Alignment::HORIZONTAL_RIGHT);

        // Add total row at the bottom
        $sheet->setCellValue("C" . ($lastRow + 1), "TOTAL");
        $sheet->setCellValue("D" . ($lastRow + 1), "=SUM(D2:D{$lastRow})");
        $sheet->setCellValue("E" . ($lastRow + 1), "=SUM(E2:E{$lastRow})");

        // Style total row
        $sheet->getStyle("C" . ($lastRow + 1) . ":E" . ($lastRow + 1))->applyFromArray([
            'font' => ['bold' => true],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'E2EFDA'], // light green
            ],
        ]);

        return [];
    }
}
