<?php

namespace App\Http\Controllers;

use App\Models\user;
use App\Models\Agency;
use App\Models\Client;
use App\Models\Department;
use App\Models\Assign;
use Illuminate\Http\Request;
use App\Models\AssignCompany;
use App\Models\AssignCompanyDepartment;
use Yajra\DataTables\DataTables;

class AssignController extends Controller
{


    public function assigns(Request $request, $id)
    {
        $user = User::find($id);

        if ($request->ajax()) {
            $data = Assign::with(['user', 'agency'])->where('user_id', $id)->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {

                    $companyAssignRoute = route('get_companyassign', $row->id);

                    $actionBtn = '
                    <div class="flex items-center justify-center gap-2">
                         <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                        <a href="' . $companyAssignRoute . '" class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md" title="View Company Assignments">
                            <i class="text-xl bx bx-link-external"></i>
                        </a>
                    </div>';
                    return $actionBtn;
                })
                ->make(true);
        }

        $agencies = Agency::all();
        return view('Admin.User.assign', compact('user', 'agencies'));
    }

    public function index(Request $request, $id)
    {
        $user = User::find($id);

        if ($request->ajax()) {
            $data = Assign::with(['user', 'agency'])->where('user_id', $id)->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    // Generate the delete route here
                    $deleteRoute = route('assign.destroy', $row->id);
                    $actionBtn = '
                        <div class="flex items-center justify-center gap-2">
                            <button onclick="openModal(\'deleteModal\', \'' . $deleteRoute . '\')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                                <i class="text-xl bx bx-trash-alt"></i>
                            </button>
                        </div>';
                    return $actionBtn;
                })
                ->make(true);
        }

        $agencies = Agency::all();
        return view('Admin.User.assign', compact('user', 'agencies'));
    }
    public function index_company(Request $request, $id)
    {
        $user = Assign::with('user')->find($id);

        if ($request->ajax()) {
            $data = AssignCompany::with(['assign', 'company'])->where('assign_id', $id)->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    $companyAssignRoute = route('get_clientassign', $row->id);

                    $actionBtn = '
                <div class="flex items-center justify-center gap-2">
                    <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                    <a href="' . $companyAssignRoute . '" class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md" title="View Company Assignments">
                        <i class="text-xl bx bx-link-external"></i>
                    </a>
                </div>';
                    return $actionBtn;
                })
                ->make(true);
        }

        $company = Client::where('agency_id', $user->agency_id)->get();
        return view('Admin.User.assigncompany', compact('user', 'company'));
    }


    public function index_client(Request $request, $id)
    {
        $user = AssignCompany::with('assign.user')->find($id);

        if ($request->ajax()) {
            $data = AssignCompanyDepartment::with(['assignCompany', 'department'])->where('assigncompany_id', $id)->get();

            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    return '
                    <div class="flex items-center justify-center gap-2">
                       <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                    </div>';
                })
                ->make(true);
        }

        $clients = Department::where('client_id', $user->company_id)->get();
        return view('Admin.User.assignclient', compact('user', 'clients'));
    }



    public function create()
    {
        return view('assign.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'agency_id' => 'required|exists:agencies,id',
        ]);

        // Check for existing assignment with the same user_id and agency_id
        $exists = Assign::where('user_id', $request->user_id)
            ->where('agency_id', $request->agency_id)
            ->exists();

        if ($exists) {
            return redirect()->back()->withErrors([
                'error' => 'This agency already assigned to this user.',
            ]);
        }

        // Create new assignment
        Assign::create($request->all());

        return redirect()->back()->with('success', 'Assignment created successfully.');
    }

    public function store_assigncompany(Request $request)
    {
        $request->validate([
            'assign_id' => 'required|exists:assign,id',
            'company_id' => 'required|exists:clients,id',
        ]);

        // Check for existing assignment with the same user_id and agency_id
        $exists = AssignCompany::where('assign_id', $request->assignagency_id)
            ->where('company_id', $request->company_id)
            ->exists();

        if ($exists) {
            return redirect()->back()->withErrors([
                'error' => 'This Company already assigned to this user.',
            ]);
        }

        // Create new assignment
        AssignCompany::create($request->all());

        return redirect()->back()->with('success', 'Assignment created successfully.');
    }


    public function store_assignclient(Request $request)
    {
        $request->validate([
            'assigncompany_id' => 'required|exists:assigncompany,id',
            'department_id' => 'required|exists:department,id',
        ]);

        // Check for existing assignment with the same user_id and agency_id
        $exists = AssignCompanyDepartment::where('assigncompany_id', $request->assigncompany_id)
            ->where('department_id', $request->department_id)
            ->exists();

        if ($exists) {
            return redirect()->back()->withErrors([
                'error' => 'This Company already assigned to this user.',
            ]);
        }

        // Create new assignment
        AssignCompanyDepartment::create($request->all());

        return redirect()->back()->with('success', 'Assignment created successfully.');
    }



    public function show(Assign $assign)
    {
        return view('assign.show', compact('assign'));
    }

    public function edit(Assign $assign)
    {
        return view('assign.edit', compact('assign'));
    }

    public function update(Request $request, Assign $assign)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'agency_id' => 'required|exists:agencies,id',
        ]);

        $assign->update($request->all());

        return redirect()->route('assign.index')->with('success', 'Assignment updated successfully.');
    }

    public function destroy(Request $request, Assign $assign)
    {
        $assign->delete();

        // Return response based on request type (AJAX or normal)
        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Assign deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Assign deleted successfully.');
    }






    public function destroy_company(Request $request, $id)
    {
        $assign = AssignCompany::findOrFail($id);
        $assign->delete();

        // Return response based on request type (AJAX or normal)
        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Assign deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Assign deleted successfully.');
    }



    public function destroy_client(Request $request, $id)
    {
        $assign = AssignCompanyDepartment::findOrFail($id);
        $assign->delete();

        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Assign Department deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Assign Department deleted successfully.');
    }
}
