<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Payroll;
use App\Models\Benefits;
use App\Models\Batchcode;
use App\Models\ClientBank;
use App\Models\Department;
use Illuminate\Http\Request;
use App\Models\OthersForPayroll;
use App\Models\EmployeeClientChannel;
use Illuminate\Support\Facades\Storage;

class BankExportController extends Controller
{
    public function generateBpiFullTxt(Request $request)
    {


        $payrollEmployeeIds = Payroll::where('code_id', $request->input('code_id'))
            ->pluck('employee_id')
            ->unique();

        $channelEmployees = EmployeeClientChannel::where('bankprofile_id', $request->input('id'))
            ->whereIn('employee_id', $payrollEmployeeIds)
            ->get();
        $date = Batchcode::find($request->input('code_id'));
        // $channelEmployees = EmployeeClientChannel::where('bankprofile_id', $request->input('id'))->get();
        $clientbank = ClientBank::where('department_id', $request->input('client_id'))->first();

        $now = now();
        $lines = [];

        $payrolls = Payroll::where('code_id', $request->input('code_id'))
            ->get()
            ->keyBy('employee_id');
        $totalDepositforheader = 0;
        $totalDeposit = 0;
        if ($request->input('id') == 11) { //SBC

            $header = '';
            $header .= 'PHP';
            $header .= '01';                              // 2. record type
            $header .= '0021143212001';         // 3. Funding Account Number
            $header .= now()->format('mdy'); // 3. Posting Date
            $header .= '200';                                 // 4.transaction code
            $header .= '0000000000125'; // 5. Amount
            $lines[] = $header;

            // Allows fast lookup by employee_id

            // === DETAIL LINES ===
            foreach ($channelEmployees as $employee) {
                $payroll = $payrolls->get($employee->employee_id);

                if (!$payroll) {
                    continue; // Skip if no payroll found (shouldn't happen if data is consistent)
                }
                $benefits = (int) round(Benefits::where('payroll_id', $payroll->id)->sum('employee_share') * 100);
                $others = (int) round(OthersForPayroll::where('payroll_id', $payroll->id)->sum('amount') * 100);
                $earnings = (int) round($payroll->earnings * 100);

                $amount = $earnings - $benefits + $others;

                $payrollDate = $date->created_at->format('dmy');
                $payroll->earnings;
                $paddedAccount = str_pad(substr($employee->bankaccount, 0, 13), 13, '0', STR_PAD_LEFT);
                $firstFour = substr($paddedAccount, 0, 4);
                $detail1 = '';
                $detail1 .= 'PHP';                                  // 1. Detail Identifier
                $detail1 .= '10';                              // 2. record type
                $detail1 .= str_pad(substr($employee->bankaccount, 0, 13), 13, '0', STR_PAD_LEFT);
                $detail1 .= str_pad($firstFour, 4, '0', STR_PAD_LEFT);


                $detail1 .= '00';                                 // 4. Reserved Field 
                $detail1 .= '70000';                               // 5. Transaction Code
                $detail1 .= str_pad($amount, 11, '0', STR_PAD_LEFT);

                $lines[] = $detail1;
                $filename = 'svc_sample_file_' . $now->format('Ymd_His') . '.txt';
            }
        } elseif ($request->input('id') == 1) { //BPI
            $hashValue = 0;

            foreach ($channelEmployees as $employee) {
                $payroll = $payrolls->get($employee->employee_id);

                if (!$payroll) {
                    continue; // Skip if no payroll found (shouldn't happen if data is consistent)
                }

                $benefits = Benefits::where('payroll_id', $payroll->id)->sum('employee_share');
                $payroll->earnings;
                $amount = (int) round(($payroll->earnings - $benefits) * 100); // Convert to cents
                $totalDepositforheader += $amount;
            }


            $header = '';
            $header .= 'H'; // 1. Header Constant
            $header .= str_pad($clientbank->company_code, 5); // 2. Company Code
            $header .= $date->created_at->format('dmy'); // 3. Payroll Date (6 chars)
            $header .= '01'; // 4. Batch Number (2 chars)
            $header .= '1'; // 5. Record Type (1 char)
            $header .= str_pad('2143176153', 10); // 6. Pay From (10 chars)
            $header .= str_pad('983', 3); // 7. Presenting Office (3 chars)
            $header .= str_pad('000001233779', 12); // 8. Ceiling Amount (12 chars)

            $header .= str_pad(substr($totalDepositforheader, 0, 12), 12, '0', STR_PAD_LEFT);

            $header .= '1'; // 10. BPI Payroll Identifier (1 char)
            $header .= str_pad('Payroll for Sample Co.', 75); // 11. Remarks (75 chars)

            $lines[] = $header;

            $hashValue = 0;
            foreach ($channelEmployees as $employee) {
                $payroll = $payrolls->get($employee->employee_id);

                if (!$payroll) {
                    continue; // Skip if no payroll found (shouldn't happen if data is consistent)
                }
                $account = (int) preg_replace('/\D/', '', substr($employee->bankaccount, 0, 10));
                $hashValue += $account;
                $benefits = Benefits::where('payroll_id', $payroll->id)->sum('employee_share');


                $payrollDate = $date->created_at->format('dmy');
                $payroll->earnings;
                $amount = (int) round(($payroll->earnings - $benefits) * 100); // Convert to cents
                $totalDeposit += $amount;
                $detail1 = '';
                $detail1 .= 'D';                                  // 1. Detail Identifier
                $detail1 .= $clientbank->company_code;                              // 2. Company Code
                $detail1 .= $date->created_at->format('dmy');                         // 3. Payroll Date
                $detail1 .= '01';                                 // 4. Batch Number
                $detail1 .= '3';                                  // 5. Record Type
                $detail1 .= str_pad(substr($employee->bankaccount, 0, 10), 10, '0', STR_PAD_LEFT);
                $detail1 .= str_pad($amount, 12, '0', STR_PAD_LEFT);  // 7. Amount
                $detail1 .= str_pad('000135412120', 12);          // 8. Hash (sample)
                $detail1 .= str_pad('', 79);                      // 9. Filler
                $lines[] = $detail1;
            }




            $trailer = '';
            $trailer .= 'T'; // 1. Trailer Constant
            $trailer .= $clientbank->company_code; // 2. Company Code
            $trailer .= $date->created_at->format('dmy'); // 3. Payroll Date
            $trailer .= '01'; // 4. Batch Number
            $trailer .= '22143176153000375803615808'; // 5. Others / Reference
            $trailer .= str_pad(substr($totalDeposit, 0, 15), 15, '0', STR_PAD_LEFT);

            $trailer .= str_pad($hashValue, 18, '0', STR_PAD_LEFT); // 7. Hash
            $trailer .= str_pad(count($channelEmployees), 6, '0', STR_PAD_LEFT); // 8. Total Count (6 digits now)
            $trailer .= str_pad('', 50); // 9. Filler (50 spaces)

            $lines[] = $trailer;
            $filename = 'bpi_sample_file_' . $now->format('Ymd_His') . '.txt';

        } elseif ($request->input('id') == 8) { //AUB

            $companyName = Department::find($request->input('client_id'))->department_name;
            $date = now()->format('Ymd'); // 8 characters
            $prefix = 'BF' . $companyName;

            // Compute remaining space to pad with spaces
            $spacesNeeded = 50 - strlen($prefix) - strlen($date);
            $spaces = str_repeat(' ', max($spacesNeeded, 0));

            // Build final header
            $header = $prefix . $spaces . $date;

            $lines[] = $header;


            foreach ($channelEmployees as $employee) {
                $payroll = $payrolls->get($employee->employee_id);

                if (!$payroll) {
                    continue; // Skip if no payroll found (shouldn't happen if data is consistent)
                }


                $benefits = (float) Benefits::where('payroll_id', $payroll->id)->sum('employee_share');
                $others = (float) OthersForPayroll::where('payroll_id', $payroll->id)->sum('amount');

                $payrollDate = now()->format('dmy'); // Use current date
                $earnings = (float) $payroll->earnings;
                $amount = $earnings - $benefits + $others;

                $totalDeposit += $amount;

                $detail1 = '';
                $detail1 .= '01';                                                // 1. Detail Identifier
                $detail1 .= str_pad(substr($employee->bankaccount, 0, 12), 12, '0', STR_PAD_LEFT); // 6. Account Number                                            // 5. Record Type
                $detail1 .= str_pad(number_format($amount, 2, '.', ''), 14, '0', STR_PAD_LEFT);  // 7. Amount (9(11).99 format)
                $detail1 .= '0000000000000000000000';     // 8. Hash (sample)
                $lines[] = $detail1;
            }

            $trailer = '';
            $trailer .= 'EF';
            $trailer .= str_pad(count($channelEmployees), 6, '0', STR_PAD_LEFT);
            $trailer .= str_pad(number_format($totalDeposit, 2, '.', ''), 15, '0', STR_PAD_LEFT);
            $trailer .= '000000000000000000000000000';     // 8. Hash (sample)


            $lines[] = $trailer;
            $filename = 'Aub_sample_file_' . $now->format('Ymd_His') . '.txt';
        }
        Storage::disk('local')->put("exports/{$filename}", implode("\r\n", $lines) . "\r\n");
        return response()->download(storage_path("app/exports/{$filename}"))->deleteFileAfterSend(true);
    }
}
