<?php

namespace App\Http\Controllers;

use App\Models\BankProfile;
use App\Models\ClientBank;
use App\Models\Department;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\Models\Batchcode;
use Illuminate\Support\Facades\Auth;
use App\Models\AssignCompany;
use App\Models\AssignCompanyDepartment;

use App\Models\Assign;
use App\Models\Payroll;
use App\Models\PersonApprove;
use App\Models\PersonInCharge;
use Carbon\Carbon;

class BankProfileController extends Controller
{



    public function client_bank(Request $request)
    {


        if ($request->ajax()) {
            $data = ClientBank::with('department', 'bankProfile')->get();

            return DataTables::of($data)

                ->addColumn('client', function ($row) {
                    return Department::find($row->department_id)->department_name ?? 'N/A';
                })
                ->addColumn('bank', function ($row) {
                    return BankProfile::find($row->bankprofile_id)->name ?? 'N/A';
                })






                ->rawColumns(['image'])
                ->make(true);
        }
        $clients = Department::all();
        $banks = BankProfile::all();

        return view('Admin.BankProfiles.clientbank', compact('clients', 'banks'));
    }





    public function bank_store(Request $request)
    {
        $validated = $request->validate([
            'bankprofile_id' => 'required|exists:bank_profiles,id',
            'department_id' => 'required|exists:department,id',
            'company_code' => 'nullable|string|max:255',
            'branch_code' => 'nullable|string|max:255',
            'filler' => 'nullable|string|max:255',
        ]);


        $bankclient = ClientBank::create($validated);

        // Return the created bank profile in JSON format
        return response()->json($bankclient, 201);  // HTTP status code 201 for created
    }



    public function bank_update(Request $request, $id)
    {
        $validated = $request->validate([
            'bankprofile_id' => 'required|exists:bank_profiles,id',
            'department_id'  => 'required|exists:department,id',
            'company_code'   => 'nullable|string|max:255',
            'branch_code' => 'nullable|string|max:255',
            'filler' => 'nullable|string|max:255',
        ]);

        $clientBank = ClientBank::findOrFail($id);

        $clientBank->update($validated);

        // Return the updated resource, including relations if you like:
        return response()->json([
            'data' => $clientBank->load(['bankProfile', 'department']),
        ], 200);
    }















    public function index(Request $request)
    {


        if ($request->ajax()) {
            $data = BankProfile::with('client')->get();

            return DataTables::of($data)
                ->addColumn('image', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';

                    // Display the image using the contact_person field which contains the image path
                    $actionBtn .= '<img src="' . asset($row->logo_path) . '" alt="Logo" width="40" height="40">'; // Adjust size as needed

                    $actionBtn .= '</div>';
                    return $actionBtn;
                })
                ->addColumn('client', function ($row) {
                    return Department::find($row->department_id)->department_name ?? 'N/A';
                })






                ->rawColumns(['image'])
                ->make(true);
        }
        $clients = Department::all();

        return view('Admin.BankProfiles.index', compact('clients'));
    }







    public function store(Request $request)
    {
        $validated = $request->validate([

            'name' => 'required|string|max:255',
            'code' => 'nullable|string|max:255',
            'swift_code' => 'nullable|string|max:255',
            'head_office' => 'nullable|string|max:255',
            'contact_email' => 'nullable|email|max:255',
            'contact_phone' => 'nullable|string|max:255',
            'website' => 'nullable|url|max:255',
            'logo' => 'nullable|image|max:2048', // Validate as image
            'description' => 'nullable|string',
        ]);

        // Handle logo upload if there is a file
        if ($request->hasFile('logo')) {

            $file = $request->file('logo');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $picturePath = 'uploads/' . $file_name;


            $validated['logo_path'] = $picturePath;
        }

        // Create the new bank profile in the database
        $bankProfile = BankProfile::create($validated);

        // Return the created bank profile in JSON format
        return response()->json($bankProfile, 201);  // HTTP status code 201 for created
    }


    public function show($id)
    {
        return response()->json(BankProfile::findOrFail($id));
    }

    public function update(Request $request, $id)
    {
        // Validate the request
        $validated = $request->validate([

            'name' => 'required|string|max:255',
            'code' => 'nullable|string|max:255',
            'swift_code' => 'nullable|string|max:255',
            'head_office' => 'nullable|string|max:255',
            'contact_email' => 'nullable|email|max:255',
            'contact_phone' => 'nullable|string|max:255',
            'website' => 'nullable|url|max:255',
            'logo' => 'nullable|image|max:2048',
            'description' => 'nullable|string',
        ]);

        // Find the bank profile to update
        $bankProfile = BankProfile::findOrFail($id);

        // Handle logo upload if there is a new file
        if ($request->hasFile('logo')) {
            // Delete the old logo if exists
            if ($bankProfile->logo_path && file_exists(public_path($bankProfile->logo_path))) {
                unlink(public_path($bankProfile->logo_path));
            }

            // Upload the new logo
            $file = $request->file('logo');
            $file_name = time() . '.' . $file->getClientOriginalExtension();
            $destination = public_path('uploads');
            $file->move($destination, $file_name);
            $picturePath = 'uploads/' . $file_name;

            // Update the logo path in the validated data
            $validated['logo_path'] = $picturePath;
        }

        // Update the bank profile with the validated data
        $bankProfile->update($validated);

        // Return the updated bank profile in JSON format
        return response()->json($bankProfile, 200);  // HTTP status code 200 for successful update
    }

    public function destroy(BankProfile $bankProfile)
    {
        // Delete the logo file if it exists
        if ($bankProfile->logo_path) {
            $logoPath = public_path('uploads/' . $bankProfile->logo_path);
            if (file_exists($logoPath)) {
                unlink($logoPath);
            }
        }

        // Delete the bank profile record
        $bankProfile->delete();

        return response()->json(['message' => 'Bank profile deleted successfully.']);
    }


    public function finalpayroll(Request $request)
    {


        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;


        // $query = BatchCode::where('status', '!=', '0')->with('client');
        $query = BatchCode::with('client');

        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });
            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            // Get the company IDs restricted via assignCompanies
            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            // Apply company restriction only if there are any
            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }

        if ($request->ajax()) {

            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('employee_count', function ($row) {

                    return Payroll::where('code_id', $row->id)
                        ->where('status', 0)
                        ->count();
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonInCharge::with('user')->where('batch_id', $row->id)->first();
                    return $user && $user->user ? $user->user->name : 'N/A';
                })
                ->addColumn('approve_by1', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();

                    if ($user && $user->user) {
                        return $user->user->name;
                    } else {
                        return 'Not Yet Approved'; // Show this when there is no user or approval data
                    }
                })
                ->addColumn('bank', function ($row) {
                    $banks = ClientBank::with('bankProfile')
                        ->where('department_id', $row->department_id)
                        ->get();

                    if ($banks->isEmpty()) {
                        return 'No bank found';
                    }

                    // Collect all bank names from the related bankProfile
                    $bankNames = $banks->map(function ($bank) {
                        return $bank->bankProfile->name ?? 'Unnamed Bank';
                    });

                    return $bankNames->implode(', ');
                })


                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"

                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('action', function ($row) {
                    $clientId = $row->payrolls->pluck('client_id')->unique()->first();


                    $banks = ClientBank::where('department_id', $row->department_id)->get();

                    // Start building the HTML for the dropdown
                    $bankOptions = '';
                    foreach ($banks as $bank) {
                        // Ensure we set the selected bankprofile_id if it exists
                        $selected = $bank->bankprofile_id == $row->bankprofile_id ? 'selected' : '';
                        $bankOptions .= "<option value=\"{$bank->bankprofile_id}\" $selected>{$bank->bankprofile->name}</option>";
                    }

                    return '
                    <div class="flex items-center justify-center gap-4">
                
                     <div>
                         <a href="' . url('admin/company-payroll/' . $row->id . '/0') . '" 
                           class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md">
                            <i class="text-xl bx bx-show"></i>
                          </a>
                     </div>
                     <div>
                       <!-- Export Header Form -->
                     <form action="' . route('bpi.export.header') . '" method="GET" class="flex items-center gap-2">

    <!-- Bank Profile Dropdown -->
              <select name="id" class="bank-select w-40  rounded-md border-2 border-black " data-id="' . $row->id . '">
              
                    ' . $bankOptions . '
                </select>>
   
          <input type="hidden" name="client_id" value="' . ($row->department_id ?? '') . '">
          <input type="hidden" name="code_id" value="' . $row->id . '">


          <button type="submit" class="px-4 py-2 text-white bg-blue-600 rounded hover:bg-blue-700">
              Download 
          </button>
      </form>

                     </div>
                  
                
                       
                    </div>';
                })

                ->rawColumns(['action'])
                ->make(true);
        }
    }
}
