<?php

namespace App\Http\Controllers;

use App\Models\Charges;
use Illuminate\Http\Request;

class ChargeController extends Controller
{
    public function index()
    {
        $charges = Charges::all();
        return view('charges.index', compact('charges'));
    }

    public function create()
    {
        return view('charges.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'client_id' => 'required|exists:clients,id', // Validate client_id
            'service_charge' => 'required|numeric',
            'vat' => 'required|numeric',
            'withholding_tax' => 'required|numeric',
        ]);

        // Add the client_id explicitly
        Charges::create([
            'client_id' => $request->client_id,
            'service_charge' => $request->service_charge,
            'vat' => $request->vat,
            'withholding_tax' => $request->withholding_tax,
        ]);

        return redirect()->back()->with('success', 'Charge created successfully.');
    }

    public function show(Charges $charge)
    {
        return view('charges.show', compact('charge'));
    }

    public function edit(Charges $charge)
    {
        return view('charges.edit', compact('charge'));
    }

    public function update(Request $request, Charges $charge)
    {
        $request->validate([
            'service_charge' => 'required|numeric',
            'vat' => 'required|numeric',
            'withholding_tax' => 'required|numeric',
        ]);

        $charge->update($request->all());

        return redirect()->route('charges.index')->with('success', 'Charge updated successfully.');
    }

    public function destroy(Charges $charge)
    {
        $charge->delete();

        return redirect()->route('charges.index')->with('success', 'Charge deleted successfully.');
    }
}
