<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Imports\WorkSchedulesImport;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{
    public function import(Request $request)
    {
        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'file' => 'required|mimes:xlsx,xls,csv',
        ]);

        $import = new WorkSchedulesImport($request->start_date, $request->end_date);
        Excel::import($import, $request->file('file'));

        return response()->json([
            'status' => 'completed',
            'rows' => $import->processedRows
        ]);
    }

}
