<?php

namespace App\Http\Controllers;

use App\Models\OtherTrx;
use App\Models\TrxCode;
use App\Models\OtherTrxOption;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class OtherTrxController extends Controller
{
    // Display a listing of OtherTrx and its associated options.
    public function others(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = OtherTrx::with('groupCode')->where('employee_id', $id)->get();
            return DataTables::of($data)

                ->addColumn('trx', function ($row) {

                    $trx = TrxCode::find($row->group_code_id);

                    return $trx->description;
                })
                ->addColumn('action', function ($row) {
                    // Action buttons (edit, delete)
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                <button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-btn" 
                data-url="' . route('other_trx.destroy', $row->id) . '" data-id="' . $row->id . '">
                <i class="text-xl bx bx-trash-alt"></i>
                </button>
            </div>';
                    return $actionBtn;
                })
                ->make(true);
        }
    }

    public function updateCheckbox(Request $request, $id)
    {
        // Find the TrxLoan by ID
        $trxLoan = OtherTrx::find($id);

        // Check if the field exists in the request and update accordingly
        if ($trxLoan) {
            $column = $request->column;
            $value = $request->value == '1' ? 1 : 0; // Set 1 for checked, 0 for unchecked

            // Update the specific field (status, 1st, or 2st)
            $trxLoan->$column = $value;
            $trxLoan->save();

            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false], 400);
    }

    // Show the form for creating a new OtherTrx.
    public function create()
    {
        return view('other_trx.create');
    }

    // Store a newly created OtherTrx in the database.
    public function store(Request $request)
    {
        // Validate request data
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'group_code_id' => 'required|exists:trx_codes,id',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'dr' => 'nullable|string',
            'status' => 'nullable|string',
            'date' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        $otherTrx = OtherTrx::create($request->all());  // Store OtherTrx

        return redirect()->back()->with('success', 'OtherTrx created successfully');
    }

    // Display the specified OtherTrx and its options.
    public function show($id)
    {
        // $otherTrx = OtherTrx::with('options')->findOrFail($id);  // Eager load options for the specific OtherTrx
        // return view('other_trx.show', compact('otherTrx'));
    }

    // Show the form for editing the specified OtherTrx.
    public function edit($id)
    {
        $otherTrx = OtherTrx::findOrFail($id);
        return view('other_trx.edit', compact('otherTrx'));
    }

    // Update the specified OtherTrx in the database.
    public function update(Request $request, $id)
    {
        $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'group_code_id' => 'required|exists:trx_codes,id',
            'trx_name' => 'nullable|string',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'dr' => 'nullable|string',
            'status' => 'nullable|string',
            'status1' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        $otherTrx = OtherTrx::findOrFail($id);
        $otherTrx->update($request->all());

        return redirect()->route('other_trx.index')->with('success', 'OtherTrx updated successfully');
    }

    // Remove the specified OtherTrx from the database.
    public function destroy($id)
    {
        $trxLoan = OtherTrx::findOrFail($id); // Ensure the record exists
        $trxLoan->delete(); // Delete the record

        return response()->json(['success' => true, 'message' => 'Loan deleted successfully!']);
    }
    // Store a newly created OtherTrxOption for a specific OtherTrx.
    public function storeOption(Request $request, $otherTrxId)
    {
        $request->validate([
            'payroll_id' => 'required|exists:payrolls,id',
            'Amount' => 'nullable|string',
            'status' => 'nullable|string',
            'descriptions' => 'nullable|string',
        ]);

        $otherTrxOption = new OtherTrxOption();
        $otherTrxOption->other_trx = $otherTrxId;
        $otherTrxOption->payroll_id = $request->payroll_id;
        $otherTrxOption->Amount = $request->Amount;
        $otherTrxOption->status = $request->status;
        $otherTrxOption->descriptions = $request->descriptions;
        $otherTrxOption->save();

        return redirect()->route('other_trx.show', $otherTrxId)->with('success', 'Option added successfully');
    }

    // Remove the specified OtherTrxOption from the database.
    public function destroyOption($id)
    {
        $otherTrxOption = OtherTrxOption::findOrFail($id);
        $otherTrxOption->delete();

        return redirect()->route('other_trx.show', $otherTrxOption->other_trx)->with('success', 'Option deleted successfully');
    }
}
