<?php

namespace App\Http\Controllers;

use App\Models\PagibigPercentage;
use Illuminate\Http\Request;

class PagibigPercentageController extends Controller
{
    /**
     * Show list of Pag-IBIG percentages.
     */
    public function index()
    {
        $rates = PagibigPercentage::latest()->get();

        return view('pagibig.index', compact('rates'));
    }

    /**
     * Show form for creating a new Pag-IBIG percentage.
     */
    public function create()
    {
        return view('pagibig.create');
    }

    /**
     * Store a newly created record in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'from' => 'required|numeric|min:0',
            'to' => 'required|numeric|min:0',
            'percent_employee' => 'nullable|numeric|min:0',
            'percent_employer' => 'nullable|numeric|min:0',
            'employee_fixedamount' => 'nullable|numeric|min:0',
            'employer_fixedamount' => 'nullable|numeric|min:0',
            'fixed1' => 'nullable|numeric|min:0',
            'fixed2' => 'nullable|numeric|min:0',
            'type' => 'required|string',
        ]);

        PagibigPercentage::create($validated);

        return redirect()->back()
            ->with('success', 'Pag-IBIG percentage added successfully.');
    }
    public function updateAll(Request $request)
    {
        foreach ($request->input('rates', []) as $id => $data) {
            $rate = PagibigPercentage::find($id);
            if ($rate) {
                $rate->update([
                    'from' => $data['from'] ?? 0,
                    'to' => $data['to'] ?? 0,
                    'percent_employee' => $data['percent_employee'] ?? null,
                    'percent_employer' => $data['percent_employer'] ?? null,
                    'employee_fixedamount' => $data['employee_fixedamount'] ?? null,
                    'employer_fixedamount' => $data['employer_fixedamount'] ?? null,
                ]);
            }
        }

        return redirect()->back()->with('success', 'Rates updated successfully.');
    }
    /**
     * Edit an existing record.
     */
    public function edit(PagibigPercentage $pagibig)
    {
        return view('pagibig.edit', compact('pagibig'));
    }

    /**
     * Update an existing record.
     */
    public function update(Request $request, PagibigPercentage $pagibig)
    {
        $validated = $request->validate([
            'from' => 'required|numeric|min:0',
            'to' => 'required|numeric|min:0',
            'percent_employee' => 'nullable|numeric|min:0',
            'percent_employer' => 'nullable|numeric|min:0',
            'employee_fixedamount' => 'nullable|numeric|min:0',
            'employer_fixedamount' => 'nullable|numeric|min:0',
            'fixed1' => 'nullable|boolean',
            'fixed2' => 'nullable|boolean',
            'type' => 'nullable|string',
        ]);

        $pagibig->update($validated);

        return redirect()->back()->with('success', 'Pag-IBIG percentage updated successfully.');
    }


    /**
     * Delete a record.
     */
    public function destroy(PagibigPercentage $pagibig)
    {
        $pagibig->delete();

        return redirect()->back()
            ->with('success', 'Pag-IBIG percentage deleted successfully.');
    }
}
