<?php

namespace App\Http\Controllers;

use App\Models\DefaultRate;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;
use App\Models\Ptsr;
use App\Models\Leave;
use App\Models\Shift;
use App\Models\OvertimeRequest;
use App\Models\Assign;
use App\Models\Client;
use App\Models\Charges;
use App\Models\Payroll;
use App\Models\PtsrTrx;
use App\Models\TrxCode;
use App\Models\TrxLoan;
use App\Models\Benefits;
use App\Models\Employee;
use App\Models\Mortuary;
use Carbon\CarbonPeriod;
use App\Models\Batchcode;
use App\Models\TrxOption;
use App\Models\Attendance;
use App\Models\Department;

use App\Models\TrxChannel;
use App\Models\TrxConstant;
use App\Models\Contribution;
use App\Models\CustomBraket;


use App\Models\Employeerate;
use App\Models\WorkSchedule;
use Illuminate\Http\Request;
use App\Models\AssignCompany;
use App\Models\CustomBenefit;
use App\Models\CustomChannel;
use App\Models\PersonApprove;
use App\Models\PersonInCharge;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\AdjustmentReport;
use App\Models\OthersForPayroll;
use Yajra\DataTables\DataTables;
use App\Models\ConstantDeduction;
use App\Models\SettingForPayroll;
use App\Models\TRXloandeductions;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Models\EmployeeClientChannel;
use App\Models\AssignCompanyDepartment;
use App\Models\Region;
use App\Models\EmployeeWageAssignment;
use App\Models\MinimumWage;
use App\Models\PagibigPercentage;
class PayrollController extends Controller
{



    public function toggleDisplayLate(Request $request, $id)
    {
        $batchcode = Batchcode::findOrFail($id);
        $batchcode->display_late = $request->input('display_late') ? 1 : 0;
        $batchcode->save();

        return response()->json(['success' => true, 'display_late' => $batchcode->display_late]);
    }



    public function downloadPayrollReport($batchId, $clientId = null)
    {
        // Increase execution time and memory limit
        ini_set('max_execution_time', 300); // 5 minutes
        ini_set('memory_limit', '1024M'); // 1 GB

        $batchCode = Batchcode::find($batchId);

        // Use chunking to avoid loading all payrolls at once
        $payrolls = collect();
        Payroll::with([
            'employee',
            'trxLoanDeductions.trxLoan.trx_code',
            'trxConstantDeductions.trxConstant.trx_code',
            'othersForPayroll',
            'benefits.client',
        ])
            ->where('code_id', $batchId)
            ->chunk(50, function ($chunk) use (&$payrolls) {
                $payrolls = $payrolls->merge($chunk);
            });

        // Preload all TrxCode descriptions to avoid repeated queries
        $trxCodeIds = $payrolls->pluck('trxConstantDeductions.*.trxConstant.group_code_id')->flatten()->unique();
        $trxCodes = TrxCode::whereIn('id', $trxCodeIds)->pluck('description', 'id');

        // Define standard benefits
        $standardBenefits = ['SSS', 'Pag-IBIG', 'PhilHealth'];

        // Preprocess payrolls to avoid loops and DB calls in Blade
        $payrollData = $payrolls->map(function ($payroll) use ($standardBenefits, $trxCodes) {
            $gross = $payroll->basic_salary + $payroll->othersForPayroll->sum('amount');
            $deductions = $payroll->trxConstantDeductions->sum('E_Amount');
            $loans = $payroll->trxLoanDeductions->sum('Amount');

            // Separate standard benefits from non-standard (move non-standard to deductions)
            $benefits = $payroll->benefits->filter(fn($b) => in_array($b->type, $standardBenefits))
                ->map(fn($b) => ['type' => $b->type, 'amount' => $b->employee_share])
                ->values();

            $nonStandardDeductions = $payroll->benefits->filter(fn($b) => !in_array($b->type, $standardBenefits))
                ->map(fn($b) => ['type' => $b->type, 'amount' => $b->employee_share])
                ->values();

            return [
                'payroll' => $payroll,
                'gross' => $gross,
                'deductions' => $deductions,
                'loans' => $loans,
                'benefits' => $benefits,
                'nonStandardDeductions' => $nonStandardDeductions,
            ];
        });

        // Collect unique headers for summary table
        $uniqueHeaders = [
            'others' => $payrolls->flatMap(fn($p) => $p->othersForPayroll->pluck('name'))->unique()->values()->all(),
            'deductions' => $payrolls->flatMap(fn($p) => $p->trxConstantDeductions->pluck('trxConstant.group_code_id'))
                ->map(fn($id) => $trxCodes[$id] ?? 'Unknown')
                ->unique()
                ->values()
                ->all(),
            'benefits' => $payrolls->flatMap(fn($p) => $p->benefits->pluck('type'))->unique()->values()->all(),
        ];

        $client = $clientId ? Department::with('client.agency')->find($clientId) : null;

        // Generate PDF
        $pdf = Pdf::loadView('Admin.Payroll.payrollbatch.reports', compact('batchCode', 'payrollData', 'uniqueHeaders', 'client'));

        return $pdf->download('payroll_report.pdf');
    }




    public function index(Request $request)
    {

        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;


        $query = BatchCode::where('status', 0)->with('client');



        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });
            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            // Get the company IDs restricted via assignCompanies
            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            // Apply company restriction only if there are any
            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }

            $clients = Client::whereHas('agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            })->get();


            $restrictedDepartmentId = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id');

            // Get the departments only for the filtered clients
            $departments = Department::find($restrictedDepartmentId);
        } else {
            $departments = Department::all();
        }

        if ($request->ajax()) {

            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('employee_count', function ($row) {
                    // Count employees with payroll records for this batch_id and status 0
                    return Payroll::where('code_id', $row->id)
                        ->where('status', 0)
                        ->count();
                })

                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('scope_period', function ($row) {
                    $startDate = Carbon::parse($row->scope_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->scope_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })

                ->addColumn('action', function ($row) {

                    return '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/company-payroll/' . $row->id . '/' . 0) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                            <i class="text-xl bx bx-show"></i>
                        </a>
                       <button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                        <i class="text-xl bx bx-trash-alt"></i>
                    </button>
                    </div>';
                })
                ->make(true);
        }

        $trx = TrxOption::where('status', 1)->get();



        $employees = Employee::all();

        $data = Payroll::with('employee', 'batchCode')->where('status', '0')->orderby('created_at', 'asc')->get();

        $clients = Client::all();
        return view('Admin.Payroll.index', compact('data', 'departments', 'clients', 'trx'));
    }

    public function deletebatch(Request $request, $id)
    {
        $batch = Batchcode::findOrFail($id);

        // Get all payrolls under this batch
        $payrolls = Payroll::where('code_id', $batch->id)->get();

        foreach ($payrolls as $payroll) {
            $payroll->trxLoanDeductions()->delete();

            $payroll->trxConstantDeductions()->delete();

            $payroll->othersForPayroll()->delete();

            $payroll->benefits()->delete();

            $payroll->delete();
        }

        // Delete the batch after all payrolls and children are gone
        $batch->delete();

        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Batch, payrolls, and related records deleted successfully.']);
        }

        return redirect()->back()->with('success', 'Batch, payrolls, and related records deleted successfully.');
    }

    public function pay_index(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = Payroll::with('client', 'othersForPayroll', 'batchCode')->where('employee_id', $id)->with('employee')->get();
            return DataTables::of($data)
                ->addColumn('earnings', function ($row) {
                    $others = OthersForPayroll::where('payroll_id', $row->id)->sum('amount') ?? 0;
                    $constantearning = ConstantDeduction::where('status', 1)
                        ->where('payroll_id', $row->id)->sum('E_Amount');

                    $earnings = $row->earnings + $constantearning + $others;

                    // Format the earnings to two decimal places
                    return number_format($earnings, 2, '.', '');
                })


                ->addColumn('bank', function ($row) {
                    // Check if bank name and bank number exist
                    $channel = EmployeeClientChannel::where('employee_id', $row->employee_id)
                        ->where('department_id', $row->department_id)->first();

                    if ($channel->bankprofile_id != null && $channel->bankaccount != null) {
                        return '<div class="flex items-center space-x-2 text-xs font-bold">'
                            . '<span>' . $channel->bankprofile->name . '</span>'
                            . '<span>- ' . $channel->bankaccount . '</span>'
                            . '</div>';
                    } else {
                        return '<div class="flex items-center space-x-2 text-xs font-bold">'
                            . '<span>To be followed</span>'
                            . '</div>';
                    }
                })


                ->addColumn('deduct', function ($row) {

                    $deductions = DB::table('loandeductions')
                        ->join('trx_loans', 'loandeductions.trx_loans_id', '=', 'trx_loans.id')
                        ->join('trx_codes', 'trx_loans.group_code_id', '=', 'trx_codes.id')
                        ->join('trx_channels', 'trx_codes.id', '=', 'trx_channels.code_id')
                        ->where('loandeductions.payroll_id', $row->id)
                        ->where('trx_channels.option_id', 7)
                        ->sum('loandeductions.Amount');

                    //for constantloan that the status is earnings
                    $constantdeduction = ConstantDeduction::whereNull('status')
                        ->where('payroll_id', $row->id)
                        ->sum('E_Amount');







                    $deductionsb = Benefits::where('payroll_id', $row->id)->sum('employee_share');


                    $totaldeductions = $deductions + $deductionsb + $constantdeduction + $row->deductions;

                    return $totaldeductions ?? 0;
                })







                ->addColumn('net_pay123', function ($row) {
                    // Use days_worked if greater than 0, else fallback
                    $daysWorked = $row->days_worked_withdeduction;

                    // Compute basic salary
                    $basicSalary = $row->earnings;

                    // Get various deductions
                    $loanDeductions = DB::table('loandeductions')
                        ->join('trx_loans', 'loandeductions.trx_loans_id', '=', 'trx_loans.id')
                        ->join('trx_codes', 'trx_loans.group_code_id', '=', 'trx_codes.id')
                        ->join('trx_channels', 'trx_codes.id', '=', 'trx_channels.code_id')
                        ->where('loandeductions.payroll_id', $row->id)
                        ->where('trx_channels.option_id', 7)
                        ->sum('loandeductions.Amount');

                    $benefitDeductions = Benefits::where('payroll_id', $row->id)->sum('employee_share');

                    $constantEarnings = ConstantDeduction::where('status', 1)
                        ->where('payroll_id', $row->id)->sum('E_Amount');

                    $otherEarnings = OthersForPayroll::where('payroll_id', $row->id)->sum('amount') ?? 0;

                    $constantDeductions = ConstantDeduction::where('status', '!=', 1)
                        ->where('payroll_id', $row->id)->sum('E_Amount');

                    // Calculate net pay
                    $netPay = $basicSalary
                        - ($row->deductions + $benefitDeductions + $loanDeductions + $constantDeductions)
                        + ($constantEarnings + $otherEarnings);

                    // Return formatted value
                    return number_format($netPay, 2, '.', '');
                })




                ->addColumn('loan_deductions', function ($row) {
                    // Return HTML formatted loan deductions (not recommended)
                    return $row->trxLoanDeductions->map(function ($loan) {
                        $code_id = TrxCode::find($loan->trxLoan->group_code_id);
                        return '<p class="">
                ' . $code_id->description . ' - ' . $loan->Amount . '</p>';
                    })->implode('');
                })

                ->addColumn('remarks', function ($row) {
                    // Return HTML formatted loan deductions (not recommended)
                    return $row->remarks ?? null;

                })
                ->addColumn('constant_deduction', function ($row) {
                    return $row->trxConstantDeductions->map(function ($loan) {
                        $code = TrxCode::find($loan->trxConstant->group_code_id);
                        if ($code->percentage != null) {

                            $percentage = ($code->percentage > 1) ? $code->percentage : ($code->percentage * 100);
                            return '<p>'
                                . $code->description . ' (' . $percentage . '%) - '
                                . $loan->E_Amount .
                                '</p>';
                        } else {
                            return '<p>'
                                . $code->description . ' - '
                                . $loan->E_Amount .
                                '</p>';
                        }
                        return ''; // Return empty string if no valid code
                    })->implode('');
                })


                ->addColumn('others', function ($row) {

                    $othersDetails = $row->othersForPayroll->map(function ($item) {
                        return $item->name . ' - ' . $item->amount;
                    })->implode('<br>');

                    return $othersDetails;
                })


                ->addColumn('benefits', function ($row) {
                    // Return HTML formatted benefits (not recommended)
                    return $row->benefits->map(function ($benefit) {
                        return '<p>' . $benefit->type . ' - Employee Share: ' . $benefit->employee_share . '</p>';
                    })->implode(''); // Joining all the formatted benefits
                })

                ->addColumn('basic_salary', function ($row) {

                    $daysWorked = $row->days_worked_withdeduction;
                    $basicSalary = $row->earnings;

                    return '<p>Basic salary - ' . $daysWorked . '<span class="ml-10">' . number_format($basicSalary, 2) . '</span></p>
                    <p>Late / Undertime - ' . $row->total_late_hours . '<span class="ml-10">' . $row->deductions . '</span></p>';
                })

                ->addColumn('batch', function ($row) {
                    // Convert the pay_period_start and pay_period_end to a more readable date format
                    $startDate = \Carbon\Carbon::parse($row->batchCode->pay_period_start)->format('F j, Y');
                    $endDate = \Carbon\Carbon::parse($row->batchCode->pay_period_end)->format('F j, Y');

                    return '<p class="text-sm font-semibold">Payroll Period - ' . $startDate . ' - ' . $endDate . '</p>';
                })

                ->rawColumns(['loan_deductions', 'remarks', 'bank', 'batch', 'others', 'constant_deduction', 'benefits', 'basic_salary', 'action'])
                ->make(true);
        }





    }


    public function create()
    {
        $employees = Employee::all();
        return view('payroll.create', compact('employees'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'pay_period_start' => 'required|date',
            'pay_period_end' => 'required|date',
            'department_id' => 'nullable',
        ]);
        $payPeriodStart = $request->input('pay_period_start');
        $payPeriodEnd = $request->input('pay_period_end');
        $department_id = $request->input('department_id');

        $user = Auth::user();
        $employeesQuery = Employee::query();
        $agencyIds = $user->viewable_agency_ids;

        // $employeesQuery->whereHas('employeerate', function ($query) {
        //     $query->whereNotNull('employee_id'); // Ensures the employee has a rate
        // });
        $employeesQuery->where(function ($query) use ($payPeriodStart, $payPeriodEnd) {
            $query->whereHas('attendance', function ($q) use ($payPeriodStart, $payPeriodEnd) {
                $q->whereBetween('date', [$payPeriodStart, $payPeriodEnd]);
            })
                ->orWhereHas('trxconstants', function ($q) {
                    $q->where('status', 1);
                })
                ->orWhereHas('ptsr', function ($q) use ($payPeriodStart, $payPeriodEnd) {
                    $q->whereDate('start_date', '<=', $payPeriodEnd)
                        ->whereDate('end_date', '>=', $payPeriodStart);
                });
        });
        if ($request->input('client_selection') == 'department') {
            $employeesQuery->whereHas('channelclient.department', function ($query) use ($department_id) {
                $query->where('id', $department_id)
                    ->where('status', 1);
            });
            $employees = $employeesQuery->get();
        }
        if (!empty($agencyIds)) {

            $employeesQuery->whereHas('channelclient.department.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();

            if ($restrictedDepartmentIds->isNotEmpty()) {

                $employeesQuery->whereHas('channelclient.department', function ($q) use ($restrictedDepartmentIds) {
                    $q->whereIn('id', $restrictedDepartmentIds);
                });
            }


            $employees = $employeesQuery->get();
        } else {
            $employees = $employeesQuery->get();
        }


        // Benfits
        $sss = Contribution::where('benefit_name', 'SSS')->latest()->first();
        $phil = Contribution::where('benefit_name', 'PhilHealth')->latest()->first();
        $pag = Contribution::where('benefit_name', 'Pag-IBIG')->latest()->first();
        // Benfits
        $debugData = [];
        $additionalBatchCodes = [];
        foreach ($employees as $employee) {

            $employeeChannel = EmployeeClientChannel::with('department', 'employee')
                ->where('employee_id', $employee->id)
                ->where('status', '1')
                ->get();
            if ($employeeChannel->isEmpty()) {
                continue;
            }

            foreach ($employeeChannel as $employeeChannel) {
                $employee_rate = Employeerate::where('status', 1)
                    ->where('employee_id', $employeeChannel->employee_id)
                    ->first();

                $dataentry = $employeeChannel->entry_time;
                $dataexit = $employeeChannel->exit_time;

                $departmentId = $employeeChannel->department_id;

                // Check if a batch code already exists for the department
                $existingBatchcode = Batchcode::where('department_id', $departmentId)
                    ->where('status', '!=', 1)
                    ->where('pay_period_start', $request->pay_period_start)
                    ->where('pay_period_end', $request->pay_period_end)
                    ->first();



                // Check payroll criteria
                $hasAttendance = Attendance::whereNull('status')->whereNotNull('approve')
                    ->whereBetween('date', [$request->pay_period_start, $request->pay_period_end])
                    ->exists();

                $hasPtsr = Ptsr::whereDate('start_date', '<=', $request->pay_period_end)
                    ->whereDate('end_date', '>=', $request->pay_period_start)
                    ->where('status', '!=', ['deduction', 'earning'])
                    ->exists();

                $hasConstantDeductions = TrxConstant::where('employee_id', $employee->id)
                    ->where('status', 1)
                    ->when($request->input('first') == 1, function ($query) {
                        return $query->where('1st', 1);
                    })
                    ->when($request->input('second') == 2, function ($query) {
                        return $query->where('2st', 1);
                    })
                    ->exists();


                if ($request->input('first') == 1) {
                    $contributiontype = 1;  // First Half
                } elseif ($request->input('second') == 2) {
                    $contributiontype = 2;  // Second Half
                } else {
                    $contributiontype = null;  // If neither checkbox is selected
                }


                if (!$request->has('additional')) {
                    if (!$existingBatchcode && ($hasAttendance || $hasPtsr || $hasConstantDeductions)) {



                        $batchCode = Batchcode::create([
                            'department_id' => $departmentId,
                            'pay_period_start' => $request->pay_period_start,
                            'pay_period_end' => $request->pay_period_end,
                            'scope_start' => $request->scope_start,
                            'scope_end' => $request->scope_end,
                            'status' => 0,
                            'contributiontype' => $contributiontype,
                            'description' => 'Payroll'
                        ]);
                    } else {

                        $batchCode = $existingBatchcode;
                    }
                } elseif ($request->has('additional')) {

                    if (!isset($additionalBatchCodes[$departmentId])) {
                        $batchCode = Batchcode::create([
                            'department_id' => $departmentId,
                            'pay_period_start' => $request->pay_period_start,
                            'pay_period_end' => $request->pay_period_end,
                            'scope_start' => $request->scope_start,
                            'scope_end' => $request->scope_end,
                            'status' => 0,
                            'contributiontype' => $contributiontype,
                            'description' => 'Additional Payroll'

                        ]);
                        $additionalBatchCodes[$departmentId] = $batchCode->id;
                    } else {
                        $batchCode = Batchcode::find($additionalBatchCodes[$departmentId]);
                    }
                }


                $attendanceCount = Attendance::where('employee_id', $employeeChannel->employee_id)->whereNotNull('approve')
                    ->whereNull('status')->whereNotNull('time_in')->whereNotNull('time_out')
                    ->whereBetween('date', [$request->pay_period_start, $request->pay_period_end])
                    ->first();



                $totalLeaveDays = Leave::where('employee_id', $employeeChannel->employee_id)
                    ->where('status', 1) // Approved
                    ->where('paid', 1)   // Paid
                    ->whereBetween('start_date', [$request->pay_period_start, $request->pay_period_end])
                    ->sum('days'); // Sum up leave days



                $ptsr = Ptsr::where('employee_id', $employeeChannel->employee_id)
                    ->whereNull('status2')
                    ->whereNotIn('status', ['deduction', 'earning'])
                    ->whereDate('start_date', $request->pay_period_start)
                    ->whereDate('end_date', $request->pay_period_end)
                    ->first();

                $debugData[] = [
                    'employee_id' => $employee->id,
                    'employee_name' => $employee->name ?? null,
                    'has_ptsr' => $ptsr ? true : false,
                    'ptsr_days' => $ptsr->number_of_days ?? null,
                    'ptsr_ot' => $ptsr->ot ?? null,
                    'ptsr_ut' => $ptsr->under_time ?? null,
                ];

                if (empty($employee_rate)) {
                    $defaultRatesOutsidePeriod = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id)
                        ->where(function ($query) use ($request) {
                            $query->where('effective_date', '<', $request->pay_period_start)
                                ->orWhere('effective_date', '>', $request->pay_period_end);
                        })
                        ->sum('amount_added');

                    $default_rate = DefaultRate::find($employeeChannel->default_rate_id);
                    $defaultRateValue = $default_rate->default_rate ?? 0;

                    $dailyRate = $defaultRateValue + $defaultRatesOutsidePeriod;

                } else {

                    $dailyRate = $employee_rate->daily_rate ?? 0;
                }



                $Data = $this->calculateHoursWorked(
                    $employeeChannel,
                    $request->pay_period_start,
                    $request->pay_period_end,
                    $dataentry,
                    $dataexit,
                    $departmentId
                );
                $minutesWorked = $Data['total_scheduled_minutes'];

                if (!$attendanceCount && !$ptsr && !$hasConstantDeductions) {
                    // Skip only if all three conditions are missing
                    continue;
                } else {
                    if (($attendanceCount && !$ptsr) || $hasConstantDeductions) {
                        // $daysWorked = $this->calculateDaysWorked($employee, $request->pay_period_start, $request->pay_period_end, $departmentId);

                        $overtimeFromForm = OvertimeRequest::where('type', 'overtime')
                            ->where('employee_id', $employeeChannel->employee_id)
                            ->where('department_id', $employeeChannel->department_id)
                            ->where('is_approved', '1')
                            ->whereNull('is_payrolled')
                            ->first();

                        $daysWorked = $this->calculateDaysWorked($employee, $request->pay_period_start, $request->pay_period_end, $departmentId);

                        $lateDeductions = $this->calculateDeductions($Data['late_minutes'], $dailyRate, $minutesWorked, $daysWorked);
                        $undertimeDeductions = $this->calculateDeductions($Data['undertime_minutes'], $dailyRate, $minutesWorked, $daysWorked);
                        // $overtimeHours = $Data['overtime_minutes'];
                        // $overtimePay = floor($overtimeHours / 60);
                        if ($overtimeFromForm) {
                            $overtimeHours = $overtimeFromForm->total_hours;
                            $overtimePay = $overtimeHours; // Already assumed to be in hours
                        } else {
                            $overtimeHours = $Data['rawot'] ?? 0;

                            // Prevent division by zero or non-numeric values
                            if (is_numeric($overtimeHours) && $overtimeHours > 0) {
                                $overtimePay = floor($overtimeHours / 60); // convert minutes to hours
                            } else {
                                $overtimePay = 0; // fallback if invalid or zero
                            }
                        }

                        $chargeSetting = Charges::where('status', '1')->where('department_id', $departmentId)->first();

                        $scheduleData = $this->calculateTotalScheduledMinutes(
                            $employeeChannel,
                            $request->pay_period_start,
                            $request->pay_period_end,
                            $dataentry,
                            $dataexit,
                            $departmentId
                        );
                        $minutesWorked = $Data['total_minutes'];
                        $totalScheduledMinutes = $scheduleData['totalMinutes'];
                        $totalScheduledDays = $scheduleData['totalDays'];

                        $affectedwageminutesWorked = $Data['adjusted_minutes'];
                        $affectedwagetotalScheduledMinutes = $scheduleData['affectedMinutes'];
                        $affectedwagetotalScheduledDays = $scheduleData['affecteddays'];


                        $expectedDailyMinutes = ($totalScheduledDays > 0) ? ($totalScheduledMinutes / $totalScheduledDays) : 0;
                        $totalWorkdaysRaw = ($expectedDailyMinutes > 0) ? ($minutesWorked / $expectedDailyMinutes) : 0;


                        $affectedwageDailyMinutes = ($affectedwagetotalScheduledDays > 0) ? ($affectedwagetotalScheduledMinutes / $affectedwagetotalScheduledDays) : 0;
                        $affectedwagetotalWorkdaysRaw = ($affectedwageDailyMinutes > 0) ? ($affectedwageminutesWorked / $affectedwageDailyMinutes) : 0;




                        if ($chargeSetting && $chargeSetting->convert_inminute == 1) {

                            $wholeDays = floor($totalWorkdaysRaw);

                            $decimalPart = $totalWorkdaysRaw - $wholeDays;

                            $extraMinutes = $decimalPart * $expectedDailyMinutes;


                            $wholeDaysadjustment = floor($affectedwagetotalWorkdaysRaw);
                            $decimalPartadjusmtment = $affectedwagetotalWorkdaysRaw - $wholeDaysadjustment;

                            $adjusntmentextraMinutes = $decimalPartadjusmtment * $affectedwageDailyMinutes;

                            // Prevent division by zero
                            if ($expectedDailyMinutes > 0 || $affectedwageDailyMinutes > 0) {
                                $fractionalDays = $extraMinutes / $expectedDailyMinutes;

                                $adjustmentfractionalDays = ($affectedwageDailyMinutes > 0)
                                    ? ($adjusntmentextraMinutes / $affectedwageDailyMinutes)
                                    : 0;
                            } else {
                                $fractionalDays = 0; // fallback if expectedDailyMinutes is zero

                                $adjustmentfractionalDays = 0;
                            }

                            $totalWorkdays = $wholeDays + $fractionalDays + $totalLeaveDays;

                            $adjsutmenttotalWorkdays = $wholeDaysadjustment + $adjustmentfractionalDays;
                        } else {
                            $totalWorkdays = number_format($totalWorkdaysRaw + $totalLeaveDays, 2);

                            $adjsutmenttotalWorkdays = number_format($affectedwagetotalWorkdaysRaw, 2);
                        }
                    } elseif (!$attendanceCount && $ptsr && !$hasConstantDeductions) {

                        $daysWorked = floatval(str_replace([' ', ',', ' '], '', $ptsr->number_of_days));
                        $lateDeductions = floatval(str_replace([' ', ',', ' '], '', 0)); // Remove spaces and commas
                        $undertimeDeductions = floatval(str_replace([' ', ',', ' '], '', $ptsr->under_time)); // Remove spaces and commas
                        $overtimeHours = floatval(str_replace([' ', ',', ' '], '', $ptsr->ot));
                        $overtimePay = $overtimeHours;
                        $minutes_work = 0;
                        $lateandundertime = $lateDeductions + $undertimeDeductions;
                        $lateDays = $lateandundertime;
                        $totalWorkdays = $daysWorked + $totalLeaveDays;
                    }

                }

                $basicSalary = $this->calculateBasicSalary($employee_rate, $dailyRate, $daysWorked);


                $grossPay = $basicSalary;


                $netPay = $this->calculateNetPay($grossPay, $lateDeductions, $undertimeDeductions);



                // Benifits Computations
                $trxOptions = DB::table('trx_constants')
                    ->join('trx_codes', 'trx_constants.group_code_id', '=', 'trx_codes.id')
                    ->join('trx_channels', 'trx_codes.id', '=', 'trx_channels.code_id')
                    ->join('trx_options', 'trx_channels.option_id', '=', 'trx_options.id')
                    ->where('trx_constants.employee_id', $employee->id)
                    ->select('trx_options.name')
                    ->distinct()
                    ->pluck('name')
                    ->toArray();

                if (!empty($employeeChannel->default_rate_id)) {

                    $minimumWages = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id)
                        ->whereBetween('effective_date', [$request->pay_period_start, $request->pay_period_end])
                        ->orderBy('effective_date', 'asc')
                        ->get();

                    $segregatedRates = [];
                    $totalAdjustmentEarnings = 0;

                    foreach ($minimumWages as $wage) {
                        $effectiveDate = Carbon::parse($wage->effective_date);

                        // Sum of previous adjustments (cumulative)
                        $previousWage = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id)
                            ->where('effective_date', '<', $effectiveDate)
                            ->sum('amount_added');

                        $currentAdjustment = $wage->amount_added;
                        $totalRate = $dailyRate + $currentAdjustment;

                        // Identify if this adjustment is a new one within the current period
                        $isNewlyAdjusted = $effectiveDate->between($request->pay_period_start, $request->pay_period_end);

                        $segregatedRates[] = [
                            'effective_date' => $effectiveDate->toDateString(),
                            'rate' => $totalRate,
                            'is_new_adjustment' => $isNewlyAdjusted,
                            'previous_adjustment' => $previousWage,
                            'current_adjustment' => $currentAdjustment,
                        ];

                        // Optional: add up earnings based on affected workdays for new adjustments
                        if ($isNewlyAdjusted) {

                            $adjustmentWorkdaysForThisRate = $adjsutmenttotalWorkdays ?? 0;

                            $totalAdjustmentEarnings += $adjustmentWorkdaysForThisRate * $totalRate;
                        }

                        $previousRate = $totalRate;
                    }

                    // Assume remaining workdays not affected by the new adjustment
                    $defaultWorkdays = $totalWorkdays - ($adjsutmenttotalWorkdays ?? 0);
                    $defaultEarnings = $defaultWorkdays * ($dailyRate ?? 0);

                    $earning = $defaultEarnings + $totalAdjustmentEarnings;
                } else {
                    $earning = $totalWorkdays * $dailyRate;
                }


                if ($batchCode) {
                    if ($ptsr) {
                        $remarks = null;
                    } else {
                        $absentRemark = !empty($Data['remarks']['absent_dates'])
                            ? '<div class="w-full pr-2">The following dates have no attendance record:<ul><li>' .
                            implode('</li><li>', array_map(
                                fn($date) => \Carbon\Carbon::parse($date)->format('l, F j, Y'),
                                $Data['remarks']['absent_dates']
                            )) .
                            '</li></ul></div>'
                            : '<div class="w-full">All dates within the period have recorded attendance.</div>';

                        if (!empty($scheduleData['remarks'])) {
                            $scheduleRemarkDiv = '<div class="w-full pr-2">' . $scheduleData['remarks'] . '</div>';
                            $remarks = '<div class="flex flex-col md:flex-row gap-4">' . $scheduleRemarkDiv . $absentRemark . '</div>';
                        } else {
                            $remarks = $absentRemark;
                        }
                    }
                    //payroll Saving
                    $payroll = Payroll::create([
                        'code_id' => $batchCode->id,
                        'employee_id' => $employee->id,
                        'department_id' => $employeeChannel->department_id,
                        'days_worked' => (!empty($totalScheduledDays) ? $totalScheduledDays : 0),
                        'days_worked_withdeduction' => $totalWorkdays,
                        'basic_salary' => $earning,
                        'workminutes' => $minutesWorked ?? 0,
                        'rate' => $dailyRate,
                        'bonus' => $dataentry,
                        'overtime' => $overtimePay,
                        'deductions' => $lateDeductions,
                        'gross_pay' => round($grossPay, 2),
                        'net_pay' => round($netPay, 2),
                        'status' => '0',
                        'payment_date' => $request->pay_period_start,
                        'remarks' => $remarks,
                        'drd' => $lateDeductions,
                        'total_late_hours' => $Data['late_minutes'],
                        'total_undertime_hours' => $Data['undertime_minutes'],
                        'earnings' => $earning,

                    ]);

                    Employee::find($payroll->employee_id)->update(['status' => 'Active']);
                    if ($payroll) {
                        if (isset($payroll->department_id)) {
                            OvertimeRequest::where('type', 'overtime')
                                ->where('employee_id', $payroll->employee_id)
                                ->where('department_id', $payroll->department_id)
                                ->where('is_approved', 1)
                                ->whereNull('is_payrolled')
                                ->update(['is_payrolled' => 1]);
                        }
                    }
                    $totalallowance = 0;
                    //payroll Saving
                    if ($request->input('10') == 10) {
                        Attendance::where('employee_id', $employee->id)->whereNotNull('approve')
                            ->whereDate('date', '>=', $request->pay_period_start)
                            ->whereDate('date', '<=', $request->pay_period_end)
                            ->whereNull('status') // Match the same conditions
                            ->update(['status' => '1']);
                        Ptsr::where('employee_id', $employee->id)
                            ->where('start_date', '=', $request->pay_period_start)
                            ->where('end_date', '=', $request->pay_period_end)
                            ->update(['status2' => 1]);


                        $overtimeFromForm = OvertimeRequest::where('type', 'overtime')
                            ->where('employee_id', $employeeChannel->employee_id)
                            ->where('department_id', $employeeChannel->department_id)
                            ->where('is_approved', '1')
                            ->whereNull('is_payrolled')
                            ->update(['is_payrolled' => 1]);


                    } else {
                        if (!empty($employee_rate)) {
                            if ($employee_rate->cola_1 != null && $employee_rate->cola_1 != 0) {
                                OthersForPayroll::create([
                                    'payroll_id' => $payroll->id,
                                    'name' => 'COLA 1',
                                    'amount' => $employee_rate->cola_1 * $totalWorkdays,
                                ]);
                                $totalallowance += $employee_rate->cola_1 * $totalWorkdays;
                            }

                            if ($employee_rate->cola_2 != null && $employee_rate->cola_2 != 0) {
                                OthersForPayroll::create([
                                    'payroll_id' => $payroll->id,
                                    'name' => 'COLA 2',
                                    'amount' => $employee_rate->cola_2 * $totalWorkdays,
                                ]);
                                $totalallowance += $employee_rate->cola_2 * $totalWorkdays;
                            }
                            if ($employee_rate->allowance != null && $employee_rate->allowance != 0) {
                                OthersForPayroll::create([
                                    'payroll_id' => $payroll->id,
                                    'name' => 'Allowance',
                                    'amount' => $employee_rate->allowance * $totalWorkdays,
                                ]);
                                $totalallowance += $employee_rate->allowance * $totalWorkdays;
                            }
                        }

                        if ($request->input('compute_13th_month') == 13) {
                            $year = request('year', date('Y'));
                            $totalBasicSalary = Payroll::where('employee_id', $employee->id)
                                ->whereYear('payment_date', $year)
                                ->sum('earnings'); // Only summing basic salary

                            $thirteenthMonthPay = $totalBasicSalary / 12;


                            OthersForPayroll::create([
                                'payroll_id' => $payroll->id,
                                'name' => '13 Month',
                                'amount' => number_format($thirteenthMonthPay, 2),
                            ]);
                        }

                        $adjustmentPrev = AdjustmentReport::with('employee')
                            ->where('employee_id', $payroll->employee_id)
                            ->where('status', 1)
                            ->get();
                        if ($adjustmentPrev->isNotEmpty()) {

                            foreach ($adjustmentPrev as $adjustment) {
                                if ($adjustment->underpayment != 0) {
                                    Benefits::create([
                                        'payroll_id' => $payroll->id,
                                        'client_id' => $employeeChannel->department->client_id,
                                        'type' => $adjustment->action,
                                        'employee_share' => $adjustment->underpayment,
                                        'employer_share' => 0,
                                    ]);
                                }
                                if ($adjustment->overpayment != 0) {
                                    OthersForPayroll::create([
                                        'payroll_id' => $payroll->id,
                                        'name' => $adjustment->action,
                                        'amount' => $adjustment->overpayment,
                                    ]);
                                }
                            }
                        }






                        // $totalOthers = 0;
                        // $totalOthersdeduction = 0;
                        $sssTotalBase = 0;
                        $pagibigTotalBase = 0;
                        $philhealthTotalBase = 0;
                        $totalOthers = 0;
                        $totalOthersdeduction = 0;
                        if (!empty($ptsr) && !empty($ptsr->id)) {


                            $ptsr_trx = PtsrTrx::with('code')->where('ptsr_id', $ptsr->id)->get();

                            foreach ($ptsr_trx as $ptsr) {
                                $trx_code1 = TrxChannel::where('code_id', $ptsr->code_id)->get();

                                // ===============================================
                                // Step 1: Compute amount
                                // ===============================================
                                if ($trx_code1->contains('option_id', 10)) {
                                    // Overtime computation
                                    $channel = $trx_code1->firstWhere('option_id', 10);

                                    $hourlyRate = $dailyRate / 8;
                                    $ot_multiplier = $channel->code->percentage / 100;
                                    $pay = round(($hourlyRate * $ot_multiplier) * $ptsr->amount, 2);

                                    $computedAmount = $pay;
                                } else {
                                    // Directly assign amount if no option_id = 10
                                    $computedAmount = $ptsr->amount;
                                }

                                // ===============================================
                                // Step 2: Decide where to save (Others or Benefits)
                                // ===============================================
                                if ($trx_code1->contains('option_id', 9)) {
                                    // Save to Others
                                    OthersForPayroll::create([
                                        'payroll_id' => $payroll->id,
                                        'code_id' => $ptsr->code_id,
                                        'name' => $ptsr->code->description,
                                        'amount' => $computedAmount,
                                    ]);

                                    $totalOthers += $computedAmount;
                                } else {
                                    // Save to Benefits
                                    Benefits::create([
                                        'payroll_id' => $payroll->id,
                                        'client_id' => $employeeChannel->department->client_id,
                                        'type' => $ptsr->code->description,
                                        'employee_share' => $computedAmount,
                                        'employer_share' => 0,
                                    ]);

                                    $totalOthersdeduction += $computedAmount;
                                    continue; // skip benefit bases
                                }

                                // ===============================================
                                // Step 3: Benefit base classification
                                // ===============================================
                                switch ($ptsr->code_id) {
                                    case 2: // SSS
                                        $sssTotalBase += $computedAmount;
                                        break;
                                    case 3: // PhilHealth
                                        $philhealthTotalBase += $computedAmount;
                                        break;
                                    case 5: // Pag-ibig
                                        $pagibigTotalBase += $computedAmount;
                                        break;
                                }
                            }
                        }


                        $trx_loans1 = TrxConstant::with('trx_code.channels.option') // Eager load trx_code, channels, and associated options
                            ->where('employee_id', $employee->id)
                            ->get();

                        foreach ($trx_loans1 as $trx_loan) {
                            $trx_code1 = TrxChannel::where('code_id', $trx_loan->group_code_id)->get();

                            foreach ($trx_code1 as $channel) {
                                $computedAmount = 0;

                                // ==================================================
                                // Step 1: Compute amount
                                // ==================================================
                                if ($channel->option_id == 10) {
                                    // Overtime computation
                                    $hourly_rate = $dailyRate / 8;
                                    $percentage = $channel->code->percentage / 100;
                                    $computedAmount = round(($hourly_rate * $percentage) * $overtimePay, 2);
                                } elseif ($channel->option_id == 4) {
                                    // 13th month computation
                                    $year = Carbon::now()->year;
                                    $startDate = $employeeChannel->created_at;
                                    $startOfYear = Carbon::parse("$year-01-01");

                                    $effectiveStartDate = $startDate > $startOfYear ? $startDate : $startOfYear;
                                    $firstPayrollDate = Payroll::where('employee_id', $employee->id)
                                        ->whereYear('created_at', $year)
                                        ->orderBy('created_at', 'asc')
                                        ->value('created_at');

                                    if ($firstPayrollDate) {
                                        $firstPayroll = Carbon::parse($firstPayrollDate);
                                        $currentDate = Carbon::now();
                                        $monthsWorked = $effectiveStartDate->diffInMonths($currentDate) + 1;
                                        $totalEarnings = Payroll::where('employee_id', $employee->id)
                                            ->whereYear('created_at', $year)
                                            ->sum('earnings');

                                        $computedAmount = round($totalEarnings / 12, 2);
                                    }
                                } else {
                                    // Direct employee share if not OT or 13th month
                                    $computedAmount = $trx_loan->employee;
                                }

                                // ==================================================
                                // Step 2: Create deduction entry
                                // ==================================================
                                if (
                                    ($trx_loan->status == 1 && $trx_loan->{'1st'} == 1 && $request->input('first') == 1) ||
                                    ($trx_loan->status == 1 && $trx_loan->{'2st'} == 1 && $request->input('second') == 2)
                                ) {
                                    ConstantDeduction::create([
                                        'trx_constants_id' => $trx_loan->id,
                                        'payroll_id' => $payroll->id,
                                        'status' => $trx_loan->dr,
                                        'E_Amount' => $computedAmount,
                                        'Er_Amount' => $trx_loan->employer,
                                    ]);

                                    // Track Others if option_id = 9
                                    if ($channel->option_id == 9) {
                                        $totalOthers += $computedAmount;
                                    } else {
                                        $totalOthersdeduction += $computedAmount;
                                    }

                                    // ==================================================
                                    // Step 3: Contribution classification
                                    // ==================================================
                                    switch ($trx_loan->group_code_id) {
                                        case 2: // SSS
                                            $sssTotalBase += $computedAmount;
                                            break;
                                        case 3: // PhilHealth
                                            $philhealthTotalBase += $computedAmount;
                                            break;
                                        case 5: // Pag-ibig
                                            $pagibigTotalBase += $computedAmount;
                                            break;
                                    }
                                }
                            }
                        }

                        // $total = ($payroll->earnings)
                        //     + ($employee_rate->allowance ?? 0)
                        //     + ($employee_rate->cola_2 ?? 0)
                        //     + ($employee_rate->cola_1 ?? 0) +
                        //     ($totalOthers ?? 0);

                        $total = ($payroll->earnings);
                        $sssTotal = $sssTotalBase + $total;
                        $pagibigTotal = $pagibigTotalBase + $total;

                        $philhealthTotal = $philhealthTotalBase + $total;


                        $currentScopeStart = $request->scope_start;

                        $latestPayroll = Payroll::whereHas('batchCode', function ($query) use ($currentScopeStart) {
                            $query->where('contributiontype', 1)
                                ->where('scope_end', $currentScopeStart);
                        })
                            ->where('employee_id', $employee->id)
                            ->orderByDesc('payment_date')
                            ->first();


                        if ($request->input('second') != 2 && $request->input('2') == 2 || in_array('Social Security System (S.S.S.) Premium', $trxOptions)) {

                            $employerShare = 0;

                            $sssContribution = $this->getSSSContribution($sssTotal, $employeeChannel->id);
                            $sss = 'SSS';
                            $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                ->where('type', $sss)
                                ->first();
                            if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                $customsss = $this->Brackets($sssTotal, $employeeChannel->id, $sss);

                                if ($customsss && isset($customsss['employee_share']) && isset($customsss['employer_share'])) {
                                    $weeklyEmployeeShare = $customsss['employee_share'];
                                    $weeklyEmployerShare = $customsss['employer_share'];
                                } else {
                                    // Fallback to default values if bracket not found or invalid
                                    $weeklyEmployeeShare = $sssContribution['employee_share'];
                                    $weeklyEmployerShare = $sssContribution['employer_share'];
                                }
                            } else {
                                $weeklyEmployeeShare = $sssContribution['employee_share'];
                                $weeklyEmployerShare = $sssContribution['employer_share'];
                            }
                        } elseif ($request->input('second') == 2 && $request->input('2') == 2 || in_array('Social Security System (S.S.S.) Premium', $trxOptions)) {


                            if ($latestPayroll) {
                                $benefitsadjustment = Benefits::where('payroll_id', $latestPayroll->id)->where('type', 'SSS')->get();

                                $monthearning = ($latestPayroll->days_worked_withdeduction * $latestPayroll->rate) + $sssTotal;

                                $employerShare = 0;
                                $sssContribution = $this->getSSSContribution($monthearning, $employeeChannel->id);


                                $sss = 'SSS';
                                $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                    ->where('type', $sss)
                                    ->first();
                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $customsss = $this->Brackets($sssTotal, $employeeChannel->id, $sss);

                                    if ($customsss && isset($customsss['employee_share']) && isset($customsss['employer_share'])) {


                                        $employee_s = $customsss['employee_share'] - $benefitsadjustment->sum('employee_share');
                                        $employeer_s = $customsss['employer_share'] - $benefitsadjustment->sum('employer_share');
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        $employee_s = $sssContribution['employee_share'] - $benefitsadjustment->sum('employee_share');
                                        $employeer_s = $sssContribution['employer_share'] - $benefitsadjustment->sum('employer_share');
                                    }
                                } else {
                                    $employee_s = $sssContribution['employee_share'] - $benefitsadjustment->sum('employee_share');
                                    $employeer_s = $sssContribution['employer_share'] - $benefitsadjustment->sum('employer_share');
                                }

                                $weeklyEmployeeShare = $employee_s;
                                $weeklyEmployerShare = $employeer_s;
                            } else {
                                // Handle the case where no matching payroll record is found
                                $employerShare = 0;
                                $sssContribution = $this->getSSSContribution($sssTotal, $employeeChannel->id);

                                $sss = 'SSS';
                                $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                    ->where('type', $sss)
                                    ->first();
                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $customsss = $this->Brackets($sssTotal, $employeeChannel->id, $sss);

                                    if ($customsss && isset($customsss['employee_share']) && isset($customsss['employer_share'])) {
                                        $weeklyEmployeeShare = $customsss['employee_share'];
                                        $weeklyEmployerShare = $customsss['employer_share'];
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        $weeklyEmployeeShare = $sssContribution['employee_share'];
                                        $weeklyEmployerShare = $sssContribution['employer_share'];
                                    }
                                } else {
                                    $weeklyEmployeeShare = $sssContribution['employee_share'];
                                    $weeklyEmployerShare = $sssContribution['employer_share'];
                                }
                            }
                        } else {
                            $weeklyEmployeeShare = 0;
                            $weeklyEmployerShare = 0;
                        }




                        // Calculate Pag-IBIG Contributions
                        $shares = $this->calculatePagibigShares($pagibigTotal);
                        if ($request->input('second') != 2 && $request->input('5') == 5 || in_array('Pag-ibig Premium', $trxOptions)) {
                            $pagibig = 'Pag-IBIG';
                            $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                ->where('type', $pagibig)
                                ->first();
                            if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                $custompagibig = $this->Brackets($pagibigTotal, $employeeChannel->id, $pagibig);

                                if ($custompagibig && isset($custompagibig['employee_share']) && isset($custompagibig['employer_share'])) {
                                    $pagibigEmployeeShare = $custompagibig['employee_share'];
                                    $pagibigEmployerShare = $custompagibig['employer_share'];
                                } else {
                                    // Fallback to default values if bracket not found or invalid
                                    // $pagibigEmployeeShare = $pagibigTotal * ($pag->employee_percentage / 100);
                                    // $pagibigEmployerShare = $pagibigTotal * ($pag->employer_percentage / 100);
                                    $pagibigEmployeeShare = $shares['employee_share'];
                                    $pagibigEmployerShare = $shares['employer_share'];
                                }
                            } else {
                                // $pagibigEmployeeShare = $pagibigTotal * ($pag->employee_percentage / 100);
                                // $pagibigEmployerShare = $pagibigTotal * ($pag->employer_percentage / 100);
                                $pagibigEmployeeShare = $shares['employee_share'];
                                $pagibigEmployerShare = $shares['employer_share'];
                            }

                            $pagibigWeeklyEmployeeShare = $pagibigEmployeeShare;
                            $pagibigWeeklyEmployerShare = $pagibigEmployerShare;
                        } elseif ($request->input('second') == 2 && $request->input('5') == 5 || in_array('Pag-ibig Premium', $trxOptions)) {

                            $pagibig = 'Pag-IBIG';
                            $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                ->where('type', $pagibig)
                                ->first();
                            if ($latestPayroll) {

                                $benefitsadjustment = Benefits::where('payroll_id', $latestPayroll->id)->where('type', 'Pag-IBIG')->get();

                                $monthearning = ($latestPayroll->days_worked_withdeduction * $latestPayroll->rate) + $pagibigTotal;
                                $shares2nd = $this->calculatePagibigShares($monthearning);

                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $custompagibig = $this->Brackets($earning, $employeeChannel->id, $pagibig);

                                    if ($custompagibig && isset($custompagibig['employee_share']) && isset($custompagibig['employer_share'])) {
                                        $pagibigEmployeeShare = $custompagibig['employee_share'];
                                        $pagibigEmployerShare = $custompagibig['employer_share'];
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        // $pagibigEmployeeShare = $monthearning * ($pag->employee_percentage / 100);
                                        // $pagibigEmployerShare = $monthearning * ($pag->employer_percentage / 100);
                                        $pagibigEmployeeShare = $shares2nd['employee_share'];
                                        $pagibigEmployerShare = $shares2nd['employer_share'];
                                    }
                                } else {
                                    // $pagibigEmployeeShare = $monthearning * ($pag->employee_percentage / 100);
                                    // $pagibigEmployerShare = $monthearning * ($pag->employer_percentage / 100);
                                    $pagibigEmployeeShare = $shares2nd['employee_share'];
                                    $pagibigEmployerShare = $shares2nd['employer_share'];
                                }

                                $pagibigWeeklyEmployeeShare = $pagibigEmployeeShare - $benefitsadjustment->sum('employee_share');
                                $pagibigWeeklyEmployerShare = $pagibigEmployerShare - $benefitsadjustment->sum('employer_share');
                            } else {
                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $custompagibig = $this->Brackets($pagibigTotal, $employeeChannel->id, $pagibig);

                                    if ($custompagibig && isset($custompagibig['employee_share']) && isset($custompagibig['employer_share'])) {
                                        $pagibigEmployeeShare = $custompagibig['employee_share'];
                                        $pagibigEmployerShare = $custompagibig['employer_share'];
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        // $pagibigEmployeeShare = $pagibigTotal * ($pag->employee_percentage / 100);
                                        // $pagibigEmployerShare = $pagibigTotal * ($pag->employer_percentage / 100);
                                        $pagibigEmployeeShare = $shares['employee_share'];
                                        $pagibigEmployerShare = $shares['employer_share'];

                                    }
                                } else {
                                    // $pagibigEmployeeShare = $pagibigTotal * ($pag->employee_percentage / 100);
                                    // $pagibigEmployerShare = $pagibigTotal * ($pag->employer_percentage / 100);
                                    $pagibigEmployeeShare = $shares['employee_share'];
                                    $pagibigEmployerShare = $shares['employer_share'];
                                }

                                $pagibigWeeklyEmployeeShare = $pagibigEmployeeShare;
                                $pagibigWeeklyEmployerShare = $pagibigEmployerShare;
                            }
                        } else {
                            $pagibigWeeklyEmployeeShare = 0;
                            $pagibigWeeklyEmployerShare = 0;
                        }


                        $phil_share = $this->calculatePhilhealthShares($philhealthTotal);
                        if ($request->input('second') != 2 && $request->input('3') == 3 || in_array('PhilHealth (Medicare)', $trxOptions)) {
                            $philhealth = 'PhilHealth';
                            $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                ->where('type', $philhealth)
                                ->first();
                            if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                $customphilhealth = $this->Brackets($philhealthTotal, $employeeChannel->id, $philhealth);

                                if ($customphilhealth && isset($customphilhealth['employee_share']) && isset($customphilhealth['employer_share'])) {
                                    $philEmployeeShare = $customphilhealth['employee_share'];
                                    $philEmployerShare = $customphilhealth['employer_share'];
                                } else {
                                    // Fallback to default values if bracket not found or invalid
                                    // $philEmployeeShare = $phil->employee_percentage;
                                    // $philEmployerShare = $phil->employer_percentage;
                                    $philEmployeeShare = $phil_share['employee_share'];
                                    $philEmployerShare = $phil_share['employer_share'];
                                }
                            } else {
                                // $philEmployeeShare = $phil->employee_percentage;
                                // $philEmployerShare = $phil->employer_percentage;
                                $philEmployeeShare = $phil_share['employee_share'];
                                $philEmployerShare = $phil_share['employer_share'];
                            }

                            $philWeeklyEmployeeShare = $philEmployeeShare;
                            $philWeeklyEmployerShare = $philEmployerShare;
                        } elseif ($request->input('second') == 2 && $request->input('3') == 3 || in_array('PhilHealth (Medicare)', $trxOptions)) {

                            $philhealth = 'PhilHealth';
                            $customBenefit = CustomBenefit::where('employee_channel_id', $employeeChannel->id)
                                ->where('type', $philhealth)
                                ->first();

                            if ($latestPayroll) {
                                $benefitsadjustment = Benefits::where('payroll_id', $latestPayroll->id)->where('type', 'PhilHealth')->get();
                                $monthearning = ($latestPayroll->basic_salary) + $philhealthTotal;
                                $phil_shares2nd = $this->calculatePhilhealthShares($monthearning);

                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $customphilhealth = $this->Brackets($monthearning, $employeeChannel->id, $philhealth);

                                    if ($customphilhealth && isset($customphilhealth['employee_share']) && isset($customphilhealth['employer_share'])) {
                                        $philEmployeeShare = $customphilhealth['employee_share'];
                                        $philEmployerShare = $customphilhealth['employer_share'];
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        // $philEmployeeShare = $phil->employee_percentage;
                                        // $philEmployerShare = $phil->employer_percentage;
                                        $philEmployeeShare = $phil_shares2nd['employee_share'];
                                        $philEmployerShare = $phil_shares2nd['employer_share'];

                                    }
                                } else {
                                    // $philEmployeeShare = $phil->employee_percentage;
                                    // $philEmployerShare = $phil->employer_percentage;
                                    $philEmployeeShare = $phil_shares2nd['employee_share'];
                                    $philEmployerShare = $phil_shares2nd['employer_share'];
                                }

                                $philWeeklyEmployeeShare = $philEmployeeShare - $benefitsadjustment->sum('employee_share');
                                $philWeeklyEmployerShare = $philEmployerShare - $benefitsadjustment->sum('employer_share');
                            } else {

                                if ($employeeChannel->cutomsetup == 1 && $customBenefit) {
                                    $customphilhealth = $this->Brackets($philhealthTotal, $employeeChannel->id, $philhealth);

                                    if ($customphilhealth && isset($customphilhealth['employee_share']) && isset($customphilhealth['employer_share'])) {
                                        $philEmployeeShare = $customphilhealth['employee_share'];
                                        $philEmployerShare = $customphilhealth['employer_share'];
                                    } else {
                                        // Fallback to default values if bracket not found or invalid
                                        // $philEmployeeShare = $phil->employee_percentage;
                                        // $philEmployerShare = $phil->employer_percentage;
                                        $philEmployeeShare = $phil_share['employee_share'];
                                        $philEmployerShare = $phil_share['employer_share'];
                                    }
                                } else {
                                    // $philEmployeeShare = $phil->employee_percentage;
                                    // $philEmployerShare = $phil->employer_percentage;
                                    $philEmployeeShare = $phil_share['employee_share'];
                                    $philEmployerShare = $phil_share['employer_share'];
                                }

                                $philWeeklyEmployeeShare = $philEmployeeShare;
                                $philWeeklyEmployerShare = $philEmployerShare;
                            }
                        } else {
                            $philWeeklyEmployeeShare = 0;
                            $philWeeklyEmployerShare = 0;
                        }

                        $totalBenefits = $philWeeklyEmployeeShare + $pagibigWeeklyEmployeeShare + $weeklyEmployeeShare;

                        $trx_loans = TrxLoan::where('employee_id', $employee->id)->get();
                        $totalloan_payment = 0;

                        $grossEarnings = $total;

                        foreach ($trx_loans as $trx_loan) {
                            // First Installment
                            if ($trx_loan->status == 1 && $trx_loan->{'1st'} == 1 && $request->input('first') == 1) {
                                if ($grossEarnings - $trx_loan->installment > 0) {
                                    TRXloandeductions::create([
                                        'trx_loans_id' => $trx_loan->id,
                                        'payroll_id' => $payroll->id,
                                        'Amount' => $trx_loan->installment,
                                    ]);
                                    $totalloan_payment += $trx_loan->installment;
                                }
                            }
                            if ($trx_loan->status == 1 && $trx_loan->{'2st'} == 1 && $request->input('second') == 2) {
                                if ($grossEarnings - $trx_loan->installment > 0) {
                                    TRXloandeductions::create([
                                        'trx_loans_id' => $trx_loan->id,
                                        'payroll_id' => $payroll->id,
                                        'Amount' => $trx_loan->installment,
                                    ]);
                                    $totalloan_payment += $trx_loan->installment;
                                }
                            }
                        }
                        $finaldeduction = $lateDeductions + $totalBenefits + $totalloan_payment + $totalOthersdeduction;

                        // total earnings before deduction
                        $totalEarnings = $grossEarnings + $totalOthers + $totalallowance;

                        // Check if earnings can cover deduction
                        if ($totalEarnings >= $finaldeduction) {
                            // proceed with full deduction
                            $earningsAfterDeduction = $totalEarnings - $finaldeduction;

                            Payroll::find($payroll->id)->update([
                                'earnings' => round($earningsAfterDeduction, 2),
                                'basic_salary' => round($grossEarnings, 2),
                                'deductions' => round($finaldeduction, 2),
                            ]);
                            if ($employeeChannel->sss != '1') {
                                $this->deductBenefit($total, $weeklyEmployeeShare, $weeklyEmployerShare, 'SSS', $payroll, $employeeChannel, $request, '2', 'Social Security System (S.S.S.) Premium');

                            }
                            if ($employeeChannel->pagibig != '1') {
                                $this->deductBenefit($total, $pagibigWeeklyEmployeeShare, $pagibigWeeklyEmployerShare, 'Pag-IBIG', $payroll, $employeeChannel, $request, '5', 'Pag-ibig Premium');

                            }
                            if ($employeeChannel->philhealth != '1') {
                                $this->deductBenefit($total, $philWeeklyEmployeeShare, $philWeeklyEmployerShare, 'PhilHealth', $payroll, $employeeChannel, $request, '3', 'PhilHealth (Medicare)');

                            }
                        } else {
                            // not enough earnings, skip deductions
                            Payroll::find($payroll->id)->update([
                                'earnings' => round($totalEarnings, 2),
                                'basic_salary' => round($grossEarnings, 2),
                                'deductions' => 0,
                                'earning_sss' => $sssTotal,
                                'earning_pagibig' => $pagibigTotal,
                                'earning_philhealth' => $philhealthTotal

                            ]);
                        }


                    }
                }
            }



            Attendance::where('employee_id', $employee->id)->whereNotNull('approve')
                ->whereDate('date', '>=', $request->pay_period_start)
                ->whereDate('date', '<=', $request->pay_period_end)
                ->whereNull('status') // Match the same conditions
                ->update(['status' => '1']);
            Ptsr::where('employee_id', $employee->id)
                ->where('start_date', '=', $request->pay_period_start)
                ->where('end_date', '=', $request->pay_period_end)
                ->update(['status2' => 1]);
            Leave::where('employee_id', $employee->id)
                ->where('status', 1) // Approved
                ->where('paid', 1)   // Paid
                ->whereBetween('start_date', [$request->pay_period_start, $request->pay_period_end])
                ->update(['status' => 2]); // Update status to 3


        }

        Batchcode::whereNotIn('id', function ($query) {
            $query->select('code_id')
                ->from('payrolls'); // Ensure batch code is actually used in payrolls
        })
            ->delete();




        return response()->json([
            'success' => true,
            'message' => 'Payroll created successfully!',
            'debug' => $debugData,
        ]);

        // return redirect()->back()->with('success', 'Payroll updated successfully!');
    }



















    // Helper Methods
    protected function calculateDaysWorked($employee, $startDate, $endDate, $departmentId = null)
    {
        $queryWithDept = Attendance::where('employee_id', $employee->id)
            ->whereNull('status')->whereNotNull('approve')
            ->whereNotNull('department_id')
            ->whereBetween('date', [$startDate, $endDate]);

        $queryWithoutDept = Attendance::where('employee_id', $employee->id)
            ->whereNull('status')
            ->whereNull('department_id')
            ->whereBetween('date', [$startDate, $endDate]);

        // If departmentId is provided and attendance has department_id, count only for that department
        if (!is_null($departmentId) && $queryWithDept->exists()) {
            return $queryWithDept->where('department_id', $departmentId)->distinct('date')->count('date');
        }

        // If there are no department-specific records, count all attendance regardless of department
        return Attendance::where('employee_id', $employee->id)
            ->whereNull('status')
            ->whereBetween('date', [$startDate, $endDate])
            ->distinct('date')
            ->count('date');
    }




    public static function calculateHoursWorked(EmployeeClientChannel $employeeChannel, $startDate, $endDate, $departmentEntryTime, $departmentExitTime, $departmentId = null)
    {
        // Fetch all approved work schedules for the pay period
        $schedules = WorkSchedule::with('shift')
            ->where('employee_id', $employeeChannel->employee_id)
            ->where('status', 'Approved')
            ->whereDate('start_date', '<=', $endDate)
            ->whereDate('end_date', '>=', $startDate)
            ->orderBy('start_date', 'asc')
            ->get();

        // Query attendance records
        $query = Attendance::where('employee_id', $employeeChannel->employee_id)
            ->whereBetween('date', [$startDate, $endDate])
            ->whereNull('status')->whereNotNull('approve');

        if (!is_null($departmentId)) {
            $query->where('department_id', $departmentId);
        }

        // Fetch attendance and group by date
        $attendances = $query->orderBy('date', 'asc')->get()
            ->groupBy('date')
            ->map(fn($entries) => $entries->whereNotNull('time_in')->whereNotNull('time_out')->first())
            ->filter();

        // Initialize totals
        $totalMinutes = 0;
        $totalScheduledMinutes = 0;
        $overtimeMinutes = 0;
        $lateMinutes = 0;
        $undertimeMinutes = 0;
        $rawot = 0;
        $workingMinutesPerDay = 480; // Standard 8-hour shift
        $adjustedMinutes = 0;
        $minimumWages = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id ?? null)
            ->whereBetween('effective_date', [$startDate, $endDate])
            ->orderBy('effective_date', 'asc')
            ->get();

        foreach ($attendances as $date => $attendance) {
            if ($attendance) {
                // Find the shift for this specific date
                $shift = $schedules->firstWhere(
                    fn($sched) =>
                    Carbon::parse($sched->start_date)->lte($date) &&
                    Carbon::parse($sched->end_date)->gte($date)
                );

                // Assign the correct shift times
                if ($employeeChannel->employee->is_shift == 1 && $shift && $shift->shift) {
                    $entryTime = $shift->shift->shift_start;
                    $exitTime = $shift->shift->shift_end;

                    // Get break times
                    $breakStart = $shift->shift->break_out;
                    $breakEnd = $shift->shift->break_in;
                } else {
                    $entryTime = $departmentEntryTime;
                    $exitTime = $departmentExitTime;
                    $breakStart = null;
                    $breakEnd = null;
                }

                // Define shift start and end for the specific day
                $shiftStart = Carbon::parse($date . ' ' . $entryTime);
                $shiftEnd = Carbon::parse($date . ' ' . $exitTime);

                if ($shiftEnd->lessThan($shiftStart)) {
                    $shiftEnd->addDay();
                }
                $lunchBreakMinutes = 0;


                if ($breakStart && $breakEnd) {
                    $breakOutTime = Carbon::parse($date . ' ' . $breakStart);
                    $breakInTime = Carbon::parse($date . ' ' . $breakEnd);

                    if ($breakInTime->lessThan($breakOutTime)) {
                        $breakInTime->addDay();
                    }

                    $lunchBreakMinutes = $breakOutTime->diffInMinutes($breakInTime);

                    $defaultBreakIn = Carbon::parse($date . ' ' . $breakEnd); // make sure it's a Carbon object
                    $actualBreakIn = $attendance->break_in ? Carbon::parse($date . ' ' . $attendance->break_in) : $defaultBreakIn;

                    $lunchBreaklate = $actualBreakIn->greaterThan($defaultBreakIn)
                        ? $actualBreakIn->diffInMinutes($defaultBreakIn)
                        : 0;
                } else {
                    // If no break is defined, use 60 minutes as the default lunch break
                    $lunchBreakMinutes = 60;
                    $lunchBreaklate = 0;
                }

                $minutesScheduled = $shiftStart->diffInMinutes($shiftEnd) - $lunchBreakMinutes;
                $totalScheduledMinutes += $minutesScheduled;

                $timeIn = Carbon::parse($date . ' ' . $attendance->time_in);
                $timeOut = $attendance->time_out ? Carbon::parse($date . ' ' . $attendance->time_out) : $shiftEnd;

                if ($timeOut->lessThan($timeIn)) {
                    $timeOut->addDay();
                }

                $dailyLateMinutes = $timeIn->greaterThan($shiftStart) ? $timeIn->diffInMinutes($shiftStart) : 0;
                $lateMinutes += $dailyLateMinutes + $lunchBreaklate;

                if ($timeIn->lessThan($shiftStart)) {
                    $timeIn = $shiftStart;
                }


                if ((int) $attendance->ot === 1) {
                    $dailyOvertimeMinutes = $timeOut->greaterThan($shiftEnd) ? $timeOut->diffInMinutes($shiftEnd) : 0;
                } else {
                    $dailyOvertimeMinutes = 0;
                }
                $overtimeMinutes += $dailyOvertimeMinutes;

                if ($timeOut->greaterThan($shiftEnd)) {
                    $timeOut = $shiftEnd;
                }

                $dailyUndertimeMinutes = $timeOut->lessThan($shiftEnd) ? $shiftEnd->diffInMinutes($timeOut) : 0;
                $undertimeMinutes += $dailyUndertimeMinutes;


                $sched123 = $shiftStart->diffInMinutes($shiftEnd);
                $halfMinutes = $sched123 / 2;
                $rawWorked = $timeIn->diffInMinutes($timeOut);

                $ot_in = Carbon::parse($date . ' ' . $attendance->ot_in);
                if ($attendance->ot_out) {
                    $ot_out = Carbon::parse($date . ' ' . $attendance->ot_out);
                    if ($ot_out->lessThan($ot_in)) {
                        $ot_out->addDay(); // handles overnight shift
                    }
                    $rawot += $ot_in->diffInMinutes($ot_out);
                }


                if ($rawWorked < $halfMinutes) {
                    $effectiveLunch = $rawWorked >= 360 ? $lunchBreakMinutes : 0;
                    $workedMinutes = max(0, $rawWorked - $effectiveLunch);
                    $totalMinutes += $workedMinutes;

                    $dailyUndertimeMinutes = $shiftEnd->diffInMinutes($timeOut, false); // false => absolute = false
                    $undertimeMinutes += $timeOut->lessThan($shiftEnd) ? $dailyUndertimeMinutes : 0;

                } else {
                    $workedMinutes = max(0, $shiftStart->diffInMinutes($shiftEnd) - $lunchBreakMinutes);
                    $totalMinutes += $workedMinutes;

                    $undertimeMinutes += $timeOut->lessThan($shiftEnd) ? $shiftEnd->diffInMinutes($timeOut) : 0;

                }
                $effectiveWage = $minimumWages->last(function ($wage) use ($date) {
                    return Carbon::parse($wage->effective_date)->lte($date);
                });

                if ($effectiveWage) {
                    $adjustedMinutes += $workedMinutes;
                }

            }
        }
        // Identify days without attendance records (absent days)
        $allDatesInRange = Carbon::parse($startDate)->toPeriod($endDate);
        $absentDates = [];

        foreach ($allDatesInRange as $day) {
            $dayStr = $day->toDateString();
            if (!isset($attendances[$dayStr])) {
                $absentDates[] = $dayStr;
            }
        }


        return [
            'rawot' => $rawot,
            'attendances' => $attendances,
            'total_minutes' => $totalMinutes,
            'total_hours' => $totalMinutes / 60,
            'overtime_minutes' => $overtimeMinutes,
            'late_minutes' => $lateMinutes,
            'undertime_minutes' => $undertimeMinutes,
            'total_scheduled_minutes' => $totalScheduledMinutes,
            'total_scheduled_hours' => $totalScheduledMinutes / 60,
            'adjusted_minutes' => $adjustedMinutes,
            'adjusted_hours' => $adjustedMinutes / 60,
            'remarks' => [
                'absent_dates' => $absentDates
            ],
        ];
    }
    public function calculateTotalScheduledMinutes($employeeChannel, $startDate, $endDate, $departmentEntryTime, $departmentExitTime, $departmentId = null)
    {
        $start = Carbon::parse($startDate);
        $end = Carbon::parse($endDate);
        $totalScheduledMinutes = 0;
        $daysScheduled = 0;
        $affectedScheduledMinutes = 0;
        $affecteddaysScheduled = 0;
        $remarks = null;
        $latestEffectiveDate = null;
        $minimumWages = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id ?? null)
            ->whereDate('effective_date', '<=', $endDate)
            ->orderBy('effective_date', 'asc')
            ->get();
        $defaultRatesOutsidePeriod = MinimumWage::where('default_rate_id', $employeeChannel->default_rate_id)
            ->where(function ($query) use ($startDate, $endDate) {
                $query->where('effective_date', '<', $startDate)
                    ->orWhere('effective_date', '>', $endDate);
            })
            ->sum('amount_added');
        $defaultRate = DefaultRate::find($employeeChannel->default_rate_id);

        while ($start->lte($end)) {
            $currentDate = $start->toDateString();

            $hasAttendance = Attendance::where('employee_id', $employeeChannel->employee_id)
                ->whereNull('status')
                ->whereNotNull('approve')
                ->whereDate('date', $currentDate)
                ->exists();

            if (!$hasAttendance) {
                $start->addDay();
                continue;
            }

            $hasAttendance = Attendance::where('employee_id', $employeeChannel->employee_id)
                ->whereNull('status')
                ->whereNotNull('approve')
                ->whereDate('date', $currentDate)
                ->exists();

            if (!$hasAttendance) {
                $start->addDay();
                continue;
            }

            $schedule = WorkSchedule::with('shift')
                ->where('employee_id', $employeeChannel->employee_id)
                ->where('status', 'Approved')
                ->whereDate('start_date', '<=', $currentDate)
                ->whereDate('end_date', '>=', $currentDate)
                ->first();

            if ($employeeChannel->employee->is_shift == 1 && $schedule && $schedule->shift) {
                $shiftStart = Carbon::parse($currentDate . ' ' . $schedule->shift->shift_start);
                $shiftEnd = Carbon::parse($currentDate . ' ' . $schedule->shift->shift_end);
                $breakOut = Carbon::parse($currentDate . ' ' . $schedule->shift->break_out);
                $breakIn = Carbon::parse($currentDate . ' ' . $schedule->shift->break_in);

                if ($breakIn->lessThan($breakOut)) {
                    $breakIn->addDay();
                }

                $lunchBreakMinutes = $breakOut->diffInMinutes($breakIn);
            } else {
                // Use default department shift and 60-minute lunch break
                $shiftStart = Carbon::parse($currentDate . ' ' . $departmentEntryTime);
                $shiftEnd = Carbon::parse($currentDate . ' ' . $departmentExitTime);
                $lunchBreakMinutes = 60;
            }

            if ($shiftEnd->lessThan($shiftStart)) {
                $shiftEnd->addDay();
            }




            $dailyScheduledMinutes = $shiftStart->diffInMinutes($shiftEnd) - $lunchBreakMinutes;
            $dailyScheduledMinutes = max($dailyScheduledMinutes, 0);



            $totalScheduledMinutes += $dailyScheduledMinutes;
            $daysScheduled++;


            $wageApplies = $minimumWages->last(function ($wage) use ($currentDate, $startDate, $endDate) {
                $effective = Carbon::parse($wage->effective_date);
                return $effective->lte($currentDate) && $effective->betweenIncluded($startDate, $endDate);
            });

            if ($wageApplies) {
                $affectedScheduledMinutes += $dailyScheduledMinutes;
                $affecteddaysScheduled++;

                $latestEffectiveDate = $wageApplies->effective_date;

            }



            $start->addDay();
        }
        if ($latestEffectiveDate && $wageApplies) {
            $formattedDate = Carbon::parse($latestEffectiveDate)->format('F j, Y');
            $currentAmountAdded = $wageApplies->amount_added ?? 0;
            $totalAmountAdded = $currentAmountAdded;
            $defaultrate = $defaultRate->default_rate + $defaultRatesOutsidePeriod;
            $remarks = 'Minimum wage adjustment effective from ' . $formattedDate .
                ' with rate ₱' . number_format($defaultrate, 2) .
                ' (Adjustment added: ₱' . number_format($totalAmountAdded, 2) . ')';
        }

        return [
            'totalMinutes' => $totalScheduledMinutes,
            'totalDays' => $daysScheduled,
            'affectedMinutes' => $affectedScheduledMinutes,
            'affecteddays' => $affecteddaysScheduled,
            'remarks' => $remarks
        ];
    }



    protected function calculateBasicSalary($employee_rate, $adjustmentwages, $daysWorked)
    {
        $salary = isset($employeeChannel->daily_rate) ? (float) $employee_rate->daily_rate + $adjustmentwages : 0.0;

        $basicPay = $salary * $daysWorked;

        return $basicPay;
    }
    protected function calculateDeductions($lateMinutes, $dailyRate, $totalMinutesWorked, $totalWorkDays)
    {
        if ($totalMinutesWorked <= 0 || $totalWorkDays <= 0) {
            return 0;
        }

        $totalEarnings = $dailyRate * $totalWorkDays;

        $ratePerMinute = $totalEarnings / $totalMinutesWorked;

        return $lateMinutes * $ratePerMinute;
    }






    protected function calculateOvertimePay($overtimeHours, $basicSalary)
    {
        return $overtimeHours * ($basicSalary / 30) * 1.5;
    }

    protected function calculateNetPay($basicSalary, $lateDeductions, $undertimeDeductions)
    {
        return $basicSalary - ($lateDeductions + $undertimeDeductions);
    }


    // public function edit($id)
    // {
    //     $payroll = Payroll::with('employee', 'client')->findOrFail($id);
    //     return response()->json($payroll);
    // }


    public function update(Request $request, $id)
    {
        // Validate the input data
        $request->validate([
            'loan_deductions.amount' => 'array', // Validate amount as an array
            'constant_deductions.amount' => 'array', // Validate amount as an array
            'others.amount' => 'array', // Validate amount as an array
            'benefits.employee_share' => 'array', // Validate employee_share as an array
            'benefits.type' => 'array', // Validate type as an array
            'rate' => 'required|numeric',
            'days_worked_withdeduction' => 'required|numeric',
        ]);


        $payroll = Payroll::findOrFail($id);


        $payroll->rate = $request->input('rate');
        $payroll->days_worked_withdeduction = $request->input('days_worked_withdeduction');
        $payroll->deductions = $request->input('deductions');
        $payroll->update();

        // Update Loan Deductions (if provided)
        if ($request->has('loan_deductions')) {
            foreach ($request->loan_deductions['id'] as $index => $loan_id) {
                $loanDeduction = TRXloandeductions::find($loan_id);
                if ($loanDeduction) {
                    $loanDeduction->update([
                        'Amount' => $request->loan_deductions['amount'][$index],
                    ]);
                }
            }
        }

        // Update Constant Deductions (if provided)
        if ($request->has('constant_deductions')) {
            foreach ($request->constant_deductions['id'] as $index => $constant_id) {
                $constantDeduction = ConstantDeduction::find($constant_id);
                if ($constantDeduction) {
                    $constantDeduction->update([
                        'E_Amount' => $request->constant_deductions['amount'][$index],
                    ]);
                }
            }
        }

        // Update Others (if provided)
        if ($request->has('others')) {
            foreach ($request->others['id'] as $index => $other_id) {
                $other = OthersForPayroll::find($other_id);
                if ($other) {
                    $other->update([
                        'amount' => $request->others['amount'][$index],
                    ]);
                }
            }
        }

        // Update Benefits (if provided)
        if ($request->has('benefits')) {
            foreach ($request->benefits['id'] as $index => $benefit_id) {
                $benefit = Benefits::find($benefit_id);
                if ($benefit) {
                    $benefit->update([
                        'type' => $request->benefits['type'][$index],
                        'employee_share' => $request->benefits['employee_share'][$index],
                    ]);
                }
            }
        }

        // Return a successful response
        return redirect()->back()->with('success', 'Payroll updated successfully!');
    }



    public function destroy($id)
    {
        $payroll = Payroll::with('employee')->findOrFail($id);
        $payroll->delete();

        return response()->json([
            'message' => $payroll->employee->last_name . ' payroll deleted successfully.'
        ]);
    }


    private function calculateHoursAndUpdatePayroll(Payroll $payroll)
    {

        $attendances = Attendance::where('employee_id', $payroll->employee_id)
            ->whereBetween('date', [$payroll->pay_period_start, $payroll->pay_period_end])
            ->get();

        $totalRegularHours = 0;
        $totalOvertimeHours = 0;

        foreach ($attendances as $attendance) {
            $timeIn = \Carbon\Carbon::parse($attendance->time_in);
            $timeOut = \Carbon\Carbon::parse($attendance->time_out);

            $hoursWorked = $timeOut->diffInHours($timeIn);

            if ($hoursWorked > 8) {
                $totalRegularHours += 8;
                $totalOvertimeHours += ($hoursWorked - 8);
            } else {
                $totalRegularHours += $hoursWorked;
            }
        }


        $employee = $payroll->employee;
        $basicPayPerHour = $employee->salary_rate / 8;
        $grossPay = $basicPayPerHour * $totalRegularHours;
        $overtimePay = $basicPayPerHour * 1.5 * $totalOvertimeHours;


        $payroll->update([
            'days_worked' => floor($totalRegularHours / 8),
            'basic_salary' => $grossPay,
            'overtime' => $overtimePay,
            'gross_pay' => $grossPay + $overtimePay,
            'net_pay' => $grossPay + $overtimePay - $payroll->deductions,
        ]);
    }



    public function payrollchecking(Request $request)
    {

        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;


        $query = BatchCode::where('status', 0)->with('client');

        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });

            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            // Get the company IDs restricted via assignCompanies
            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            // Apply company restriction only if there are any
            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }

        if ($request->ajax()) {

            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('employee_count', function ($row) {
                    // Count employees with payroll records for this batch_id and status 0
                    return Payroll::where('code_id', $row->id)
                        ->where('status', 0)
                        ->count();
                })

                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('scope_period', function ($row) {
                    $startDate = Carbon::parse($row->scope_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->scope_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })

                ->addColumn('action', function ($row) {

                    return '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/company-payroll/' . $row->id . '/' . 0) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                            <i class="text-xl bx bx-show"></i>
                        </a>
                        <button onclick="openDeleteModal(\'' . $row->id . '\', \'' . route('delete.batch', $row->id) . '\')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md edit"><i class="bx bxs-trash"></i></button>
         
                    </div>';
                })
                ->make(true);
        }
        $clients = Client::all();
        $departments = Department::all();
        return view('Admin.Payroll.check.index', compact('clients', 'departments'));
    }



    public function updatebatch($id)
    {
        // Find the batch by ID
        $batch = Batchcode::find($id);

        if (!$batch) {
            return redirect()->back()->with('error', 'Batch ID ' . $id . ' not found.');
        }

        // Update the status to the desired value, e.g., 0 (or any status value)
        $batch->status = 0;  // Change this to the desired status value (e.g., 0 for "inactive")
        $batch->save();  // Save the updated status

        return redirect()->back()->with('success', 'Batch ID ' . $id . ' status successfully updated to 0.');
    }


    public function finalpayroll(Request $request)
    {

        $user = Auth::user();

        $agencyIds = $user->viewable_agency_ids;


        $query = BatchCode::where('status', '!=', '0')->with('client');

        if (!empty($agencyIds)) {

            $query->whereHas('client.client.agency', function ($q) use ($agencyIds) {
                $q->whereIn('id', $agencyIds);
            });
            $assignIds = Assign::where('user_id', $user->id)
                ->whereIn('agency_id', $agencyIds)
                ->pluck('id');

            // Get the company IDs restricted via assignCompanies
            $restrictedCompanyIds = AssignCompany::whereIn('assign_id', $assignIds)
                ->pluck('id');

            $restrictedDepartmentIds = AssignCompanyDepartment::whereIn('assigncompany_id', $restrictedCompanyIds)
                ->pluck('department_id')
                ->unique();


            // Apply company restriction only if there are any
            if ($restrictedDepartmentIds->isNotEmpty()) {
                $query->whereIn('department_id', $restrictedDepartmentIds);
            }
        }

        if ($request->ajax()) {

            $data = $query->get();

            return DataTables::of($data)

                ->addColumn('employee_count', function ($row) {

                    return Payroll::where('code_id', $row->id)
                        ->where('status', 0)
                        ->count();
                })
                ->addColumn('approve_by', function ($row) {
                    $user = PersonInCharge::with('user')->where('batch_id', $row->id)->first();
                    return $user && $user->user ? $user->user->name : 'N/A';
                })
                ->addColumn('approve_by1', function ($row) {
                    $user = PersonApprove::with('user')->where('batch_id', $row->id)->first();

                    if ($user && $user->user) {
                        return $user->user->name;
                    } else {
                        return 'Not Yet Approved'; // Show this when there is no user or approval data
                    }
                })
                ->addColumn('pay_period', function ($row) {
                    $startDate = Carbon::parse($row->pay_period_start)->format('F j, Y'); // formats as "January 21, 2025"
                    $endDate = Carbon::parse($row->pay_period_end)->format('F j, Y'); // formats as "January 25, 2025"
    
                    return $startDate . ' - ' . $endDate;
                })
                ->addColumn('action', function ($row) {

                    $clientId = $row->payrolls->pluck('client_id')->unique()->first();

                    return '<div class="flex items-center justify-center gap-2">
                        <a href="' . url('admin/company-payroll/' . $row->id . '/' . 0) . '" class="flex items-center justify-center w-10 h-10 text-white bg-green-600 rounded-md edit">
                            <i class="text-xl bx bx-show"></i>
                        </a>
                    </div>';
                })


                ->rawColumns(['action'])
                ->make(true);
        }

        return view('Admin.Payroll.payrollbatch.index');
    }
    public function viewpayroll(Request $request, $batch_id, $status)
    {
        $data = Batchcode::with('client')->find($batch_id);

        $trx_loan = TRXloandeductions::where('payroll_id')->get();


        $payrolls = Payroll::with(['trxLoanDeductions.trxLoan.trx_code', 'trxConstantDeductions.trxConstant.trx_code', 'othersForPayroll', 'benefits.client'])
            ->where('code_id', $batch_id)
            ->where('status', $status)
            ->get();




        if ($request->ajax()) {

            $data = Payroll::with('client.client.agency', 'employee', 'othersForPayroll', 'batchCode')->where('code_id', $batch_id)->where('status', $status);

            return DataTables::of($data)


                ->addColumn('earnings', function ($row) {

                    $others = OthersForPayroll::where('payroll_id', $row->id)->sum('amount');
                    $earnings = $row->basic_salary + $others;

                    // Format the earnings to two decimal places
                    return number_format($earnings, 2, '.', '');
                })


                ->addColumn('bank', function ($row) {
                    // Check if bank name and bank number exist
                    $channel = EmployeeClientChannel::where('employee_id', $row->employee_id)
                        ->where('department_id', $row->department_id)->first();

                    if ($channel->bankprofile_id != null && $channel->bankaccount != null) {
                        return '<div class="flex items-center space-x-2 text-xs font-bold">'
                            . '<span>' . $channel->bankprofile->name . '</span>'
                            . '<span>- ' . $channel->bankaccount . '</span>'
                            . '</div>';
                    } else {
                        return '<div class="flex items-center space-x-2 text-xs font-bold">'
                            . '<span>To be followed</span>'
                            . '</div>';
                    }
                })


                ->addColumn('deduct', function ($row) {

                    $deductions = DB::table('loandeductions')
                        ->join('trx_loans', 'loandeductions.trx_loans_id', '=', 'trx_loans.id')
                        ->join('trx_codes', 'trx_loans.group_code_id', '=', 'trx_codes.id')
                        ->join('trx_channels', 'trx_codes.id', '=', 'trx_channels.code_id')
                        ->where('loandeductions.payroll_id', $row->id)
                        ->where('trx_channels.option_id', 7)
                        ->sum('loandeductions.Amount');

                    //for constantloan that the status is earnings
                    $constantdeduction = ConstantDeduction::whereNull('status')
                        ->where('payroll_id', $row->id)
                        ->sum('E_Amount');







                    $deductionsb = Benefits::where('payroll_id', $row->id)->sum('employee_share');


                    $totaldeductions = $row->deductions;

                    return $totaldeductions ?? 0;
                })







                ->addColumn('net_pay123', function ($row) {

                    $netPay = $row->earnings;

                    return number_format($netPay, 2, '.', '');
                })




                ->addColumn('loan_deductions', function ($row) {
                    // Return HTML formatted loan deductions (not recommended)
                    return $row->trxLoanDeductions->map(function ($loan) {
                        $code_id = TrxCode::find($loan->trxLoan->group_code_id);
                        return '<p class="">
                        ' . $code_id->description . ' - ' . $loan->Amount . '</p>';
                    })->implode('');
                })

                ->addColumn('remarks', function ($row) {
                    // Return HTML formatted loan deductions (not recommended)
                    return $row->remarks ?? null;

                })


                ->addColumn('constant_deduction', function ($row) {
                    return $row->trxConstantDeductions->map(function ($loan) {
                        $code = TrxCode::find($loan->trxConstant->group_code_id);
                        if ($code->percentage != null) {

                            $percentage = ($code->percentage > 1) ? $code->percentage : ($code->percentage * 100);
                            return '<p>'
                                . $code->description . ' (' . $percentage . '%) - '
                                . $loan->E_Amount .
                                '</p>';
                        } else {
                            return '<p>'
                                . $code->description . ' - '
                                . $loan->E_Amount .
                                '</p>';
                        }
                        return ''; // Return empty string if no valid code
                    })->implode('');
                })


                ->addColumn('others', function ($row) {

                    $othersDetails = $row->othersForPayroll->map(function ($item) {
                        return $item->name . ' - ' . $item->amount;
                    })->implode('<br>');

                    return $othersDetails;
                })


                ->addColumn('benefits', function ($row) {
                    return $row->benefits
                        ->filter(function ($benefit) {
                            return in_array($benefit->type, ['SSS', 'Pag-IBIG', 'PhilHealth']);
                        })
                        ->map(function ($benefit) {
                            return '<p>' . $benefit->type . ' - Employee Share: ' . $benefit->employee_share . '</p>';
                        })
                        ->implode('');
                })

                ->addColumn('deductions_from_benefits', function ($row) {
                    return $row->benefits
                        ->filter(function ($benefit) {
                            return !in_array($benefit->type, ['SSS', 'Pag-IBIG', 'PhilHealth']);
                        })
                        ->map(function ($benefit) {
                            return '<p>' . $benefit->type . ' - ' . $benefit->employee_share . '</p>';
                        })
                        ->implode('');
                })

                ->addColumn('basic_salary', function ($row) {
                    $daysWorked = $row->days_worked_withdeduction;
                    $basicSalary = $row->basic_salary;

                    $html = '<p>Basic salary - ' . $daysWorked . '<span class="ml-10">' . number_format($basicSalary, 2) . '</span></p>';

                    if ($row->drd > 0) {
                        $html .= '<p>Late / Undertime - ' . $row->total_late_hours . '<span class="ml-10">' . number_format($row->drd, 2) . '</span></p>';
                    }

                    return $html;
                })





                // <button onclick="openEditModal(' . $row->id . ')" class="px-2 py-2 text-white bg-blue-500 rounded"><i class="text-xl bx bx-edit"></i></button> 

                ->addColumn('action', function ($row) {
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';

                    // Check the batch status and generate action buttons accordingly
                    if ($row->batchCode->status == 0) {
                        // View button
                        $actionBtn .= ' <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->employee_id)) . '" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md edit">
                                            <i class="text-sm bx bx-show"></i>
                                          </a>';

                        // Edit button (Redirect to the edit page with the payroll id)
                        $actionBtn .= ' <a href="' . route('payrolls.edit', $row->id) . '" class="flex items-center justify-center w-8 h-8 text-white bg-blue-600 rounded-md edit">
                                            <i class="text-sm bx bx-edit"></i>
                                          </a>';

                        // Delete button
                        $actionBtn .= ' <button onclick="confirmDeletePayroll(' . $row->id . ')" class="px-2 py-1 text-white bg-red-500 rounded">
                                            <i class="text-sm bx bx-trash"></i>
                                          </button>';
                    } else {
                        // If status is not 0, show the view button only
                        $actionBtn .= ' <a href="' . url('admin/pre-profile/' . Crypt::encrypt($row->employee_id)) . '" class="flex items-center justify-center w-8 h-8 text-white bg-green-600 rounded-md edit">
                                            <i class="text-sm bx bx-show"></i>
                                          </a>';
                    }

                    // Close the action buttons container
                    $actionBtn .= '</div>';

                    // Return the complete action buttons HTML
                    return $actionBtn;
                })


                ->rawColumns(['loan_deductions', 'deductions_from_benefits', 'remarks', 'bank', 'others', 'constant_deduction', 'benefits', 'basic_salary', 'action'])
                ->make(true);
        }

        $groupedDeductions = [];

        foreach ($payrolls as $payroll) {
            foreach ($payroll->trxConstantDeductions as $deduction) {
                $groupId = $deduction->trxConstant->group_code_id ?? null;
                if ($groupId === null)
                    continue;

                if (!isset($groupedDeductions[$groupId])) {
                    $groupedDeductions[$groupId] = [
                        'description' => optional(TrxCode::find($groupId))->description,
                        'earnings' => 0,
                        'deductions' => 0,
                    ];
                }

                if ($deduction->status == 1) {
                    $groupedDeductions[$groupId]['earnings'] += $deduction->E_Amount;
                } elseif ($deduction->status == 0 || $deduction->status == null) {
                    $groupedDeductions[$groupId]['deductions'] += $deduction->E_Amount;
                }
            }
        }





        $prepared = PersonInCharge::with('user')->where('batch_id', $batch_id)->first();
        $approved = PersonApprove::with('user')->where('batch_id', $batch_id)->first();
        return view('Admin.Payroll.payrollbatch.viewpayroll', compact('batch_id', 'status', 'data', 'prepared', 'approved', 'groupedDeductions', 'payrolls'));
    }
    public function edit($id)
    {
        // Fetch the payroll record
        $payroll = Payroll::findOrFail($id);

        // Fetch Loan Deductions (if any)
        $benefits = Benefits::where('payroll_id', $id)->get();


        // $loan_deductions = DB::table('loandeductions')
        //     ->join('trx_loans', 'loandeductions.trx_loans_id', '=', 'trx_loans.id')
        //     ->join('trx_codes', 'trx_loans.group_code_id', '=', 'trx_codes.id')
        //     ->join('trx_channels', 'trx_codes.id', '=', 'trx_channels.code_id')
        //     ->where('loandeductions.payroll_id', $id)
        //     ->where('trx_channels.option_id', 7)
        //     ->get();

        $loan_deductions = TRXloandeductions::where('payroll_id', $id)->get();
        // Fetch Constant Earnings (if any)
        $constantearning = ConstantDeduction::where('payroll_id', $id)->get();

        // Fetch Constant Deductions (if any)

        // Fetch Other Deductions (if any)
        $others = OthersForPayroll::where('payroll_id', $id)->get();

        // Pass the data to the view
        return view('Admin.Payroll.payrollbatch.edit', compact(
            'payroll',
            'loan_deductions',
            'benefits',
            'constantearning',
            'others'
        ));
    }

    private function getSSSContribution($earning, $id)
    {


        $sssBrackets = [
            [0, 5250, 5000, "-", 5000, 500, "-", 10, 510, 250, "-", 250],
            [5250, 5749.99, 5500, "-", 5500, 550, "-", 10, 560, 275, "-", 275],
            [5750, 6249.99, 6000, "-", 6000, 600, "-", 10, 610, 300, "-", 300],
            [6250, 6749.99, 6500, "-", 6500, 650, "-", 10, 660, 325, "-", 325],
            [6750, 7249.99, 7000, "-", 7000, 700, "-", 10, 710, 350, "-", 350],
            [7250, 7749.99, 7500, "-", 7500, 750, "-", 10, 760, 375, "-", 375],
            [7750, 8249.99, 8000, "-", 8000, 800, "-", 10, 810, 400, "-", 400],
            [8250, 8749.99, 8500, "-", 8500, 850, "-", 10, 860, 425, "-", 425],
            [8750, 9249.99, 9000, "-", 9000, 900, "-", 10, 910, 450, "-", 450],
            [9250, 9749.99, 9500, "-", 9500, 950, "-", 10, 960, 475, "-", 475],
            [9750, 10249.99, 10000, "-", 10000, 1000, "-", 10, 1010, 500, "-", 500],
            [10250, 10749.99, 10500, "-", 10500, 1050, "-", 10, 1060, 525, "-", 525],
            [10750, 11249.99, 11000, "-", 11000, 1100, "-", 10, 1110, 550, "-", 550],
            [11250, 11749.99, 11500, "-", 11500, 1150, "-", 10, 1160, 575, "-", 575],
            [11750, 12249.99, 12000, "-", 12000, 1200, "-", 10, 1210, 600, "-", 600],
            [12250, 12749.99, 12500, "-", 12500, 1250, "-", 10, 1260, 625, "-", 625],
            [12750, 13249.99, 13000, "-", 13000, 1300, "-", 10, 1310, 650, "-", 650],
            [13250, 13749.99, 13500, "-", 13500, 1350, "-", 10, 1360, 675, "-", 675],
            [13750, 14249.99, 14000, "-", 14000, 1400, "-", 10, 1410, 700, "-", 700],
            [14250, 14749.99, 14500, "-", 14500, 1450, "-", 30, 1480, 725, "-", 725],
            [14750, 15249.99, 15000, "-", 15000, 1500, "-", 30, 1530, 750, "-", 750],
            [15250, 15749.99, 15500, "-", 15500, 1550, "-", 30, 1580, 775, "-", 775],
            [15750, 16249.99, 16000, "-", 16000, 1600, "-", 30, 1630, 800, "-", 800],
            [16250, 16749.99, 16500, "-", 16500, 1650, "-", 30, 1680, 825, "-", 825],
            [16750, 17249.99, 17000, "-", 17000, 1700, "-", 30, 1730, 850, "-", 850],
            [17250, 17749.99, 17500, "-", 17500, 1750, "-", 30, 1780, 875, "-", 875],
            [17750, 18249.99, 18000, "-", 18000, 1800, "-", 30, 1830, 900, "-", 900],
            [18250, 18749.99, 18500, "-", 18500, 1850, "-", 30, 1880, 925, "-", 925],
            [18750, 19249.99, 19000, "-", 19000, 1900, "-", 30, 1930, 950, "-", 950],
            [19250, 19749.99, 19500, "-", 19500, 1950, "-", 30, 1980, 975, "-", 975],
            [19750, 20249.99, 20000, "-", 20000, 2000, "-", 30, 2030, 1000, "-", 1000],
            [20250, 20749.99, 20000, 500, 20500, 2000, 50, 30, 2080, 1000, 25, 1025],
            [20750, 21249.99, 20000, 1000, 21000, 2000, 100, 30, 2130, 1000, 50, 1050],
            [21250, 21749.99, 20000, 1500, 21500, 2000, 150, 30, 2180, 1000, 75, 1075],
            [21750, 22249.99, 20000, 2000, 22000, 2000, 200, 30, 2230, 1000, 100, 1100],
            [22250, 22749.99, 20000, 2500, 22500, 2000, 250, 30, 2280, 1000, 125, 1125],
            [22750, 23249.99, 20000, 3000, 23000, 2000, 300, 30, 2330, 1000, 150, 1150],
            [23250, 23749.99, 20000, 3500, 23500, 2000, 350, 30, 2380, 1000, 175, 1175],
            [23750, 24249.99, 20000, 4000, 24000, 2000, 400, 30, 2430, 1000, 200, 1200],
            [24250, 24749.99, 20000, 4500, 24500, 2000, 450, 30, 2480, 1000, 225, 1225],
            [24750, 25249.99, 20000, 5000, 25000, 2000, 500, 30, 2530, 1000, 250, 1250],
            [25250, 25749.99, 20000, 5500, 25500, 2000, 550, 30, 2580, 1000, 275, 1275],
            [25750, 26249.99, 20000, 6000, 26000, 2000, 600, 30, 2630, 1000, 300, 1300],
            [26250, 26749.99, 20000, 6500, 26500, 2000, 650, 30, 2680, 1000, 325, 1325],
            [26750, 27249.99, 20000, 7000, 27000, 2000, 700, 30, 2730, 1000, 350, 1350],
            [27250, 27749.99, 20000, 7500, 27500, 2000, 750, 30, 2780, 1000, 375, 1375],
            [27750, 28249.99, 20000, 8000, 28000, 2000, 800, 30, 2830, 1000, 400, 1400],
            [28250, 28749.99, 20000, 8500, 28500, 2000, 850, 30, 2880, 1000, 425, 1425],
            [28750, 29249.99, 20000, 9000, 29000, 2000, 900, 30, 2930, 1000, 450, 1450],
            [29250, 29749.99, 20000, 9500, 29500, 2000, 950, 30, 2980, 1000, 475, 1475],
            [29750, 30249.99, 20000, 10000, 30000, 2000, 1000, 30, 3030, 1000, 500, 1500],
            [30250, 30749.99, 20000, 10500, 30500, 2000, 1050, 30, 3080, 1000, 525, 1525],
            [30750, 31249.99, 20000, 11000, 31000, 2000, 1100, 30, 3130, 1000, 550, 1550],
            [31250, 31749.99, 20000, 11500, 31500, 2000, 1150, 30, 3180, 1000, 575, 1575],
            [31750, 32249.99, 20000, 12000, 32000, 2000, 1200, 30, 3230, 1000, 600, 1600],
            [32250, 32749.99, 20000, 12500, 32500, 2000, 1250, 30, 3280, 1000, 625, 1625],
            [32750, 33249.99, 20000, 13000, 33000, 2000, 1300, 30, 3330, 1000, 650, 1650],
            [33250, 33749.99, 20000, 13500, 33500, 2000, 1350, 30, 3380, 1000, 675, 1675],
            [33750, 34249.99, 20000, 14000, 34000, 2000, 1400, 30, 3430, 1000, 700, 1700],
            [34250, 34749.99, 20000, 14500, 34500, 2000, 1450, 30, 3480, 1000, 725, 1725]
        ];


        // Find the correct bracket
        foreach ($sssBrackets as $bracket) {
            if ($earning >= $bracket[0] && $earning <= $bracket[1]) {
                return [
                    'employee_share' => $bracket[11], // Employee Regular SS
                    'employer_share' => $bracket[8], // Employer EC Contribution

                ];
            }
        }

        return ['employee_share' => 0, 'employer_share' => 0]; // Default if no match

    }
    private function calculatePagibigShares($pagibigTotal)
    {
        $bracket = PagibigPercentage::where('from', '<=', $pagibigTotal)
            ->where('to', '>=', $pagibigTotal)
            ->first();

        if (!$bracket) {
            return [
                'employee_share' => 0,
                'employer_share' => 0,
            ];
        }

        // Employee Share
        $employeeShare = ($bracket->fixed1 == 1)
            ? $bracket->employee_fixedamount
            : $pagibigTotal * ($bracket->percent_employee / 100);

        // Employer Share
        $employerShare = ($bracket->fixed2 == 1)
            ? $bracket->employer_fixedamount
            : $pagibigTotal * ($bracket->percent_employer / 100);



        return [
            'employee_share' => $employeeShare,
            'employer_share' => $employerShare,
        ];
    }
    private function calculatePhilhealthShares($philhealthTotal)
    {
        $bracket = PagibigPercentage::where('type', 'philhealth')->where('from', '<=', $philhealthTotal)
            ->where('to', '>=', $philhealthTotal)
            ->first();

        if (!$bracket) {
            return [
                'employee_share' => 0,
                'employer_share' => 0,
            ];
        }

        // Employee Share
        $employeeShare = ($bracket->fixed1 == 1)
            ? $philhealthTotal * ($bracket->percent_employer / 100)
            : $bracket->employee_fixedamount;

        // Employer Share
        $employerShare = ($bracket->fixed1 == 1)
            ? $philhealthTotal * ($bracket->percent_employer / 100)
            : $bracket->employer_fixedamount;



        return [
            'employee_share' => $employeeShare,
            'employer_share' => $employerShare,
        ];
    }

    private function Brackets($earning, $id, $type)
    {


        $employee = EmployeeClientChannel::find($id);

        if (!$employee) {
            return ['employee_share' => 0, 'employer_share' => 0]; // Return default if employee is not found
        }


        $customBenefit = CustomBenefit::where('employee_channel_id', $employee->id)
            ->where('type', $type)
            ->first();

        if ($customBenefit) {
            // Get all associated CustomChannels for the CustomBenefit
            $customChannels = CustomChannel::where('custombenefits_id', $customBenefit->id)->get();

            foreach ($customChannels as $customChannel) {
                // Get the CustomBraket associated with the CustomChannel
                $customBraket = CustomBraket::find($customChannel->custombracket_id);
                if ($customBraket) {
                    // Check if the earnings are null
                    if ($earning === null) {
                        return ['employee_share' => 0, 'employer_share' => 0]; // Default if earnings are not set
                    }

                    // Check if the earnings are within the custom bracket range
                    if ($earning < $customBraket->start_range) {
                        // If earnings are lower than the lowest range, use the lowest range
                        return [
                            'employee_share' => $customBraket->employee_rate, // Custom employee rate from the bracket
                            'employer_share' => $customBraket->employeer_rate, // Custom employer rate from the bracket
                            'bracket_range' => [
                                'start' => $customBraket->start_range, // Custom bracket start range
                                'end' => $customBraket->end_range,     // Custom bracket end range
                            ],
                        ];
                    } elseif ($earning > $customBraket->end_range) {
                        // If earnings exceed the highest range, use the highest rate in the bracket
                        return [
                            'employee_share' => $customBraket->employee_rate, // Custom employee rate from the highest range
                            'employer_share' => $customBraket->employeer_rate, // Custom employer rate from the highest range
                            'bracket_range' => [
                                'start' => $customBraket->start_range, // Custom bracket start range
                                'end' => $customBraket->end_range,     // Custom bracket end range
                            ],
                        ];
                    } else {
                        // If earnings are within the range, use the appropriate bracket
                        return [
                            'employee_share' => $customBraket->employee_rate, // Custom employee rate from the bracket
                            'employer_share' => $customBraket->employeer_rate, // Custom employer rate from the bracket
                            'bracket_range' => [
                                'start' => $customBraket->start_range, // Custom bracket start range
                                'end' => $customBraket->end_range,     // Custom bracket end range
                            ],
                        ];
                    }
                }
            }
        }
    }






    private function deductBenefit(&$total, $employeeShare, $employerShare, $type, $payroll, $employeeChannel, $request, $inputKey, $benefitName)
    {
        if ($total > 0 && $employeeShare > 0) {
            if ($request->input($inputKey) == $inputKey || in_array($benefitName, $request->input('trxOptions', []))) {


                if ($total - $employeeShare > 0) {
                    Benefits::create([
                        'payroll_id' => $payroll->id,
                        'client_id' => $employeeChannel->department->client_id,
                        'type' => $type,

                        'employee_share' => $employeeShare,
                        'employer_share' => $employerShare,
                    ]);
                    $total -= $employeeShare;
                }
            }
        }
    }
}
