<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Privilege;
use App\Models\Role;
use Yajra\DataTables\DataTables;

class RoleController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Role::get();
            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    // Start constructing the action buttons
                    $actionBtn = '<div class="flex items-center justify-center gap-2">';

                    // Add the edit button
                    $actionBtn .= '<button onclick="openModal(\'updateroleModal' . $row->id . '\')" 
                                 class="flex items-center justify-center w-10 h-10 text-white bg-blue-600 rounded-md delete">
                                 <i class="bx bx-edit-alt"></i>
                               </button>';

                    // Conditionally add the delete button
                    if (!in_array($row->id, [1, 2, 9, 8])) {
                        $actionBtn .= '<button onclick="openDeleteModal(' . $row->id . ')" class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md">
                            <i class="text-xl bx bx-trash-alt"></i>
                        </button>';
                    }


                    $actionBtn .= '</div>';

                    return $actionBtn;
                })


                ->make(true);
        }
    }

    public function edit(Role $role)
    {
        $privileges = Privilege::all();
        return view('roles.edit', compact('role', 'privileges'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'role_name' => 'required|string|max:255',
            'privileges' => 'array',
            'privileges.*' => 'exists:privileges,id',
        ]);

        $role = Role::create($request->only('role_name'));

        // Sync selected privileges
        $role->privileges()->sync($request->privileges);

        return redirect()->back()->with('success', 'Role created successfully.');
    }

    public function update(Request $request, Role $role)
    {
        $request->validate([
            'role_name' => 'required|string|max:255',
            'privileges' => 'array',
            'privileges.*' => 'exists:privileges,id',
        ]);

        $role->update($request->only('role_name'));

        // Sync selected privileges
        $role->privileges()->sync($request->privileges);

        return redirect()->back()->with('success', 'Role updated successfully.');
    }

    public function destroy(Role $role)
    {
        $role->privileges()->detach();
        $role->delete();

        return response()->json(['success' => true, 'message' => 'Record deleted successfully.']);
    }
}
