<?php

namespace App\Http\Controllers;

use App\Models\SettingForBilling;
use Illuminate\Http\Request;

class SettingForBillingController extends Controller
{
    // Display a listing of the resource
    public function index()
    {
        $settings = SettingForBilling::with('client')->paginate(10); // Paginated listing with client relationship
        return view('settings-for-billing.index', compact('settings'));
    }

    // Show the form for creating a new resource
    public function create()
    {
        return view('settings-for-billing.create');
    }

    // Store a newly created resource in storage
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'client_id' => 'required|exists:clients,id',
            'regular_column' => 'nullable|string',
            'drd_column' => 'nullable|string',
            'lh_column' => 'nullable|string',
            'sh_column' => 'nullable|string',
            'ot_column' => 'nullable|string',
            'gross_pay' => 'nullable|string',
            'thirtheen_month' => 'nullable|string',
            'benefits' => 'nullable|string',
        ]);

        $setting = SettingForBilling::create($validatedData);

        return response()->json([
            'message' => 'Setting created successfully!',
            'data' => $setting
        ], 201);
    }


    // Display the specified resource
    public function show(SettingForBilling $settings_for_billing)
    {
        return view('settings-for-billing.show', compact('settings_for_billing'));
    }

    // Show the form for editing the specified resource
    public function edit(SettingForBilling $settings_for_billing)
    {
        return view('settings-for-billing.edit', compact('settings_for_billing'));
    }

    // Update the specified resource in storage

    public function update(Request $request, $id)
    {
        // Validate the incoming data
        $validatedData = $request->validate([
            'regular_column' => 'nullable|string',
            'drd_column' => 'nullable|string',
            'lh_column' => 'nullable|string',
            'sh_column' => 'nullable|string',
            'ot_column' => 'nullable|string',
            'gross_pay' => 'nullable|string',
            'thirtheen_month' => 'nullable|string',
            'benefits' => 'nullable|string',
        ]);

        // Find the setting record
        $setting = SettingForBilling::findOrFail($id);


        $setting->update([
            'regular_column' => $validatedData['regular_column'] ?? false,
            'drd_column' => $validatedData['drd_column'] ?? false,
            'lh_column' => $validatedData['lh_column'] ?? false,
            'sh_column' => $validatedData['sh_column'] ?? false,
            'ot_column' => $validatedData['ot_column'] ?? false,
            'gross_pay' => $validatedData['gross_pay'] ?? false,
            'thirtheen_month' => $validatedData['thirtheen_month'] ?? false,
            'benefits' => $validatedData['benefits'] ?? false,
        ]);

        // Return JSON for AJAX requests
        if ($request->ajax()) {
            return response()->json(['message' => 'Settings updated successfully!'], 200);
        }

        // Redirect for non-AJAX requests
        return redirect()
            ->route('settings.index') // Assuming 'settings.index' is the route name for listing settings
            ->with('success', 'Settings updated successfully!');
    }
    // Remove the specified resource from storage
    public function destroy(SettingForBilling $settings_for_billing)
    {
        $settings_for_billing->delete();

        return redirect()->route('settings-for-billing.index')
            ->with('success', 'Setting deleted successfully!');
    }
}
