<?php

namespace App\Http\Controllers;

use App\Models\TrxConstant;
use App\Models\TrxCode;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class TrxConstantController extends Controller
{
    public function employee_loans(Request $request, $id)
    {
        if ($request->ajax()) {
            $data = TrxConstant::with('trx_code')->where('employee_id', $id)->get();
            return DataTables::of($data)
                ->addColumn('description_code', function ($row) {

                    $trx = TrxCode::find($row->group_code_id);

                    return $trx->description;
                })
                ->addColumn('action', function ($row) {
                    // Action buttons (edit, delete)
                    $actionBtn = '<div class="flex items-center justify-center gap-2">
                <button class="flex items-center justify-center w-10 h-10 text-white bg-red-600 rounded-md delete-btn" 
                data-url="' . route('trx_constants.destroy', $row->id) . '" data-id="' . $row->id . '">
                <i class="text-xl bx bx-trash-alt"></i>
                </button>
            </div>';
                    return $actionBtn;
                })
                ->make(true);
        }
    }


    public function updateCheckbox(Request $request, $id)
    {
        // Find the TrxLoan by ID
        $trxLoan = TrxConstant::find($id);

        // Check if the field exists in the request and update accordingly
        if ($trxLoan) {
            $column = $request->column;
            $value = $request->value == '1' ? 1 : 0; // Set 1 for checked, 0 for unchecked

            // Update the specific field (status, 1st, or 2st)
            $trxLoan->$column = $value;
            $trxLoan->save();

            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false], 400);
    }

    public function create()
    {
        return view('trx_constants.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            'group_code_id' => 'required',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'dr' => 'nullable|string',
            'status' => 'nullable|string',
            'employee' => 'nullable|string',
            'employer' => 'nullable|string',
            'ec' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        TrxConstant::create($validated);

        return redirect()->back()->with('success', 'Added Successfully.');
    }

    public function show($id)
    {
        return TrxConstant::findOrFail($id);
    }

    public function edit($id)
    {
        $trxConstant = TrxConstant::findOrFail($id);
        return view('trx_constants.edit', compact('trxConstant'));
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'employee_id' => 'required|exists:employees,id',
            '1st' => 'nullable|string',
            '2st' => 'nullable|string',
            'dr' => 'nullable|string',
            'status' => 'nullable|string',
            'employee' => 'nullable|string',
            'employer' => 'nullable|string',
            'ec' => 'nullable|string',
            'description' => 'nullable|string',
        ]);

        $trxConstant = TrxConstant::findOrFail($id);
        $trxConstant->update($validated);

        return redirect()->route('trx_constants.index');
    }

    public function destroy($id)
    {
        $trxConstant = TrxConstant::findOrFail($id);
        $trxConstant->delete();

        return response()->json(['success' => true, 'message' => 'Loan deleted successfully!']);
    }
}
