<?php

namespace App\Http\Controllers;

use App\Models\TrxOption;
use App\Models\TrxChannel;
use App\Models\TrxGroupcode;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class TrxGroupcodeController extends Controller
{
    public function index(Request $request)
    {
        $options = TrxOption::all();
        $groupCodes = TrxGroupcode::all();
        $groupcodes = TrxGroupcode::all();
        $trxChannels = TrxChannel::get();

        if ($request->ajax()) {
            $data = TrxGroupcode::all();
            return DataTables::of($data)
                ->addColumn('action', function ($row) {
                    // Generate the edit button with the correct data attributes
                    return '<button class="btn btn-info bg-blue-500 text-white p-2 rounded-md" 
                    onclick="openEditModal(this)" 
                    data-id="' . $row->id . '"
                    data-description="' . $row->description . '">
                Edit
            </button>';
                })
                ->make(true);
        }

        return view('Admin.Payroll.TRX.index', compact('groupcodes', 'groupCodes', 'options', 'trxChannels'));
    }

    public function create()
    {
        return view('trx_groupcodes.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'description' => 'required|string|max:255',
        ]);
        TrxGroupcode::create($request->all());
        return redirect()->back()->with('success', 'Group code created successfully.');
    }

    public function show(TrxGroupcode $trxGroupcode)
    {
        return view('trx_groupcodes.show', compact('trxGroupcode'));
    }

    public function edit(TrxGroupcode $trxGroupcode)
    {
        return view('trx_groupcodes.edit', compact('trxGroupcode'));
    }

    public function update(Request $request, TrxGroupcode $trxGroupcode)
    {
        $request->validate([
            'description' => 'required|string|max:255',
        ]);

        $trxGroupcode->update($request->all());
        return redirect()->back()->with('success', 'Group code updated successfully.');
    }














    public function destroy(TrxGroupcode $trxGroupcode)
    {
        $trxGroupcode->delete();
        return redirect()->route('trx-groupcodes.index')->with('success', 'Group code deleted successfully.');
    }
}
