<?php

namespace App\Http\Controllers;

use App\Models\TrxOption;
use Illuminate\Http\Request;

class TrxOptionController extends Controller
{
    public function index()
    {
        // Fetch all options and pass to the view
        $options = TrxOption::all();
        return view('trx_options.index', compact('options'));
    }

    public function create()
    {
        return view('trx_options.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        TrxOption::create($request->all());

        return redirect()->back()->with('success', 'Option created successfully.');
    }



    public function updateStatus(Request $request)
    {
        // Validate the incoming request
        $request->validate([
            'option_ids' => 'nullable|array', // Can be null if no checkbox is selected
            'option_ids.*' => 'exists:trx_options,id', // Validate each ID
        ]);

        // Retrieve all TrxOptions
        $allOptions = TrxOption::all();

        // Update status for each option
        foreach ($allOptions as $option) {
            if ($request->option_ids && in_array($option->id, $request->option_ids)) {
                // If option ID is in the submitted array, set status to 1
                $option->update(['status' => 1]);
            } else {
                // If option ID is not in the array, set status to 0
                $option->update(['status' => 0]);
            }
        }

        // Redirect back with success message
        return redirect()->back()->with('success', 'Options statuses updated successfully.');
    }
    public function show(TrxOption $trxOption)
    {
        return view('trx_options.show', compact('trxOption'));
    }

    public function edit(TrxOption $trxOption)
    {
        return view('trx_options.edit', compact('trxOption'));
    }

    public function update(Request $request, TrxOption $trxOption)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $trxOption->update($request->all());

        return redirect()->route('trx-options.index')->with('success', 'Option updated successfully.');
    }

    public function destroy(TrxOption $trxOption)
    {
        $trxOption->delete();

        return redirect()->route('trx-options.index')->with('success', 'Option deleted successfully.');
    }
}
