<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdjustmentReport extends Model
{
    use HasFactory;
    protected $table = 'adjustment_report';

    protected $fillable = [
        'batch_id',
        'employee_id',
        'action',
        'remarks',
        'underpayment',
        'overpayment',
        'status',
    ];


    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }


    public function batch()
    {
        return $this->belongsTo(Batchcode::class);
    }

    public $timestamps = true;
}
