<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Agency extends Model
{
    use HasFactory;

    protected $table = 'agencies';

    protected $fillable = [
        'user_id',
        'name',
        'contact_person',
        'contact_phone',
        'address',
    ];

    public function companies()
    {
        return $this->hasMany(Client::class, 'agency_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function assigns()
    {
        return $this->hasMany(Assign::class, 'agency_id');
    }
}
