<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Assign extends Model
{
    use HasFactory;
    protected $table = 'assign';
    protected $fillable = ['user_id', 'agency_id'];

    // Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relationship with Agency
    public function agency()
    {
        return $this->belongsTo(Agency::class);
    }
    public function assignCompanies()
    {
        return $this->hasMany(AssignCompany::class, 'assign_id');
    }
}
