<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignCompanyDepartment extends Model
{
    use HasFactory;

    protected $table = 'assignclient'; // Use your actual table name

    protected $fillable = [
        'assigncompany_id',
        'department_id',
    ];

    // Define relationships (adjust class names if needed)
    public function assignCompany()
    {
        return $this->belongsTo(AssignCompany::class, 'assigncompany_id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }
}
