<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankLog extends Model
{
    use HasFactory;


    protected $table = 'bank_logs';

    protected $primaryKey = 'id';

    protected $fillable = [
        'assignemployee_id',
        'user_id',
        'date',
        'action',
        'remarks',
        'file',
    ];

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $dates = [
        'date',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
