<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BankProfile extends Model
{
    use HasFactory;

    protected $fillable = [

        'name',
        'code',
        'swift_code',
        'head_office',
        'contact_email',
        'contact_phone',
        'website',
        'logo_path',
        'description',
    ];


    public function client()
    {
        return $this->belongsto(Client::class, 'department_id');
    }
}
