<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Benefits extends Model
{
    use HasFactory;
    protected $table = 'benefits';

    // The attributes that are mass assignable
    protected $fillable = [
        'payroll_id',
        'client_id',
        'type',
        'contribution',
        'employee_share',
        'employer_share',
        'e_adjustment',
        'er_adjustment',
    ];
    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
}
