<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Billing extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'batch_id',
        'charge_id',
        'note',
        'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function charges()
    {
        return $this->belongsTo(Charges::class);
    }
    public function billingAdjustments()
    {
        return $this->hasMany(BillingAdjustment::class);
    }
}
