<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillingAdjustment extends Model
{
    use HasFactory;
    protected $table = "billingadjustment";
    protected $fillable = [
        'billing_id',
        'payroll_id',
    ];

    public function billing()
    {
        return $this->belongsTo(Billing::class);
    }

    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }
}
