<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Charges extends Model
{
    use HasFactory;
    protected $table = 'charges';
    protected $fillable = [
        'department_id',
        'status',
        'service_charge',
        'charge_amount',
        'vat',
        'withholding_tax',
        'service_charge_type',
        'convert_inminute',
        'special_rate_service',
        'special_rate_vat',
        's_camputation_for_all',
        'v_camputation_for_all',
        'w_camputation_for_all',
        'start_date',
        'end_date',
        's_sss',
        's_phil',
        's_pagibig',
        'v_sss',
        'v_phil',
        'v_pagibig',
        'w_sss',
        'w_phil',
        'w_pagibig'



    ];
    public function department()
    {
        return $this->belongsTo(Department::class);
    }
    public function chargeGroups()
    {
        return $this->hasMany(ChargeGroup::class, 'charges_id');
    }
}
