<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClearanceLog extends Model
{
    use HasFactory;

    protected $table = 'clearance_logs'; // Specify the table name (optional if it follows convention)

    // Define the fillable attributes for mass assignment
    protected $fillable = [
        'employee_id',
        'user_id',
        'date',
        'action',
        'remarks',
        'cheque',
        'amount'
    ];

    // If employee is a related model, you can define a relationship:
    public function employee()
    {
        return $this->belongsTo(Employee::class); // Assuming you have an Employee model
    }
}
