<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Client extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'agency_id',
        'business_name',
        'owner_name',
        'address',
        'date_of_employment',
        'contact_number',
    ];
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function departments()
    {
        return $this->hasMany(Department::class);
    }

    public function agency()
    {
        return $this->belongsTo(Agency::class, 'agency_id');
    }
}
