<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $table = 'companies';

    protected $fillable = [
        'user_id',
        'agency_id',
        'name',
        'contact_person',

        'contact_phone',
        'address',
        'industry',
    ];

    public function agency()
    {
        return $this->belongsTo(Agency::class, 'agency_id');
    }

    public function clients()
    {
        return $this->hasMany(Client::class, 'company_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
