<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomBenefit extends Model
{
    protected $table = 'custombenefits';

    protected $fillable = [
        'employee_channel_id',
        'type',
    ];

    public $timestamps = false;

    protected $casts = [
        'created-at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function customChannels()
    {
        return $this->hasMany(CustomChannel::class, 'custombenefits_id');
    }
    public function employeeChannel()
    {
        return $this->belongsTo(EmployeeClientChannel::class, 'employee_channel_id');
    }
}
