<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomChannel extends Model
{
    protected $table = 'custom_channel';

    protected $fillable = [
        'custombenefits_id',
        'custombracket_id',
    ];

    public $timestamps = true;

    public function benefit()
    {
        return $this->belongsTo(CustomBenefit::class, 'custombenefits_id');
    }

    public function bracket()
    {
        return $this->belongsTo(CustomBraket::class, 'custombracket_id');
    }
}
