<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{
    use HasFactory;
    protected $table = 'department';
    protected $fillable = ['user_id', 'client_id', 'department_name', 'start', 'end', 'billing_status'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
    public function channels()
    {
        return $this->hasMany(EmployeeClientChannel::class);
    }

    public function requisition()
    {
        return $this->hasMany(Requisition::class);
    }
    public function employeeClientChannels()
    {
        return $this->hasMany(EmployeeClientChannel::class);
    }
    public function batchcode()
    {
        return $this->hasMany(Batchcode::class);
    }
}
