<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class DepartmentStore extends Model
{
    use HasFactory;

    protected $table = 'department_stores';

    protected $fillable = [
        'department_id',
        'store_id',
    ];

    public $timestamps = true;

    // Relationships
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function store()
    {
        return $this->belongsTo(stores::class); // assuming your store model is named `stores`
    }
}
