<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DtrRequest extends Model
{
    use HasFactory;

    // Specify the table name if it doesn't follow Laravel's naming convention
    protected $table = 'dtr_request';

    // The attributes that are mass assignable
    protected $fillable = [
        'employee_id',
        'date',
        'type',
        'time',
        'status'
    ];

    // If you want to cast the 'date' and 'time' fields to proper types
    protected $casts = [
        'date' => 'date',
        'time' => 'datetime:H:i:s', // only the time part
    ];

    // If you are using timestamps
    public $timestamps = true;

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
