<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class EmployeeClientChannel extends Model
{
    use HasFactory;


    protected $table = 'assignemployeee';

    protected $fillable = [
        'department_id',
        'store_id',
        'employee_id',
        'bankprofile_id',
        'default_rate_id',
        'bankaccount',
        'bankfile',
        'dtr_id',
        'position',
        'date_hired',
        'employment_start_date',
        'employment_end_date',
        'bank_status',
        'entry_time',
        'exit_time',
        'status',
        'cutomsetup',
        'sss',
        'pagibig',
        'philhealth'
    ];

    // Define relationships
    public function bankprofile()
    {
        return $this->belongsTo(BankProfile::class, 'bankprofile_id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
    public static function getAssignedEmployees()
    {
        return self::where('status', 1)->get();  // Only employees with status = 1 (assigned)
    }
    public function default_rate()
    {
        return $this->belongsTo(DefaultRate::class, foreignKey: 'default_rate_id');
    }

    // Define a method to get employees who are not assigned
    public static function getNotAssignedEmployees()
    {
        return Employee::whereDoesntHave('employeeClientChannels')  // Check for employees with no relation in employeeClientChannels
            ->orWhereHas('employeeClientChannels', function ($query) {
                $query->where('status', '!=', 1);  // Exclude employees with status = 1 (not assigned)
            })
            ->get();
    }
}
