<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employeerate extends Model
{
    use HasFactory;

    // Define the table name (optional if table name follows Laravel's convention)
    protected $table = 'employeerate';

    // Mass-assignable fields
    protected $fillable = [
        'employee_id',
        'status',
        'date',
        'monthly_salary',
        'daily_rate',
        'cola_1',
        'cola_2',
        'allowance',
    ];

    // Define the relationship with the Employee model
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
}
