<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Leave extends Model
{
    use HasFactory;
    protected $table = 'leaves';

    // The attributes that are mass assignable
    protected $fillable = [
        'employee_id',
        'leave_type',
        'start_date',
        'end_date',
        'days',
        'paid',
        'status',
        'reason',
    ];
    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
