<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;

    protected $fillable = [
        'payroll_id',
        'capital',
        'loans',
        'c_loans',
        'mortuary'
    ];

    /**
     * Get the payroll associated with the loan.
     */
    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }
}
