<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MrfAction extends Model
{
    use HasFactory;

    protected $table = 'mrf_actions';

    protected $fillable = [
        'mrf_id',
        'user_id',
        'action',
    ];

    /**
     * Get the user associated with the action.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the requisition associated with the action.
     */
    public function requisition()
    {
        return $this->belongsTo(Requisition::class, 'mrf_id');
    }
}
