<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MrfApplicant extends Model
{
    use HasFactory;

    // Specify the table if it's not the plural form of the model name
    protected $table = 'mrf_applicant';

    // Mass assignable attributes
    protected $fillable = [
        'requisition_id',
        'employee_id',
        'status',
    ];

    // Relationships
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    public function requisition()
    {
        return $this->belongsTo(Requisition::class, 'requisition_id');
    }
    public function applicantLogs()
    {
        return $this->hasMany(ApplicantLog::class, 'applicant_id');
    }
}
