<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OthersForPayroll extends Model
{
    use HasFactory;
    protected $table = 'others_for_payroll';  // This is optional if you follow Laravel's convention

    protected $fillable = [
        'payroll_id',
        'code_id',
        'name',
        'amount',
        'amount_adj',
    ];

    // Define the relationship to the Payroll model
    public function payroll()
    {
        return $this->belongsTo(Payroll::class);
    }
}
