<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OvertimeRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'type',
        'department_id',
        'position',
        'request_date',
        'regular_start',
        'regular_end',
        'actual_start',
        'actual_end',
        'total_hours',
        'reason',
        'is_approved',
        'approved_by',
        'approved_at',
        'is_payrolled',
        'payroll_notes',
    ];


    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }
    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
