<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payroll extends Model
{
    use HasFactory;

    protected $fillable = [
        'code_id',
        'department_id',
        'employee_id',
        'days_worked',
        'days_worked_withdeduction',
        'workminutes',
        'basic_salary',
        'earning_sss',
        'earning_pagibig',
        'earning_philhealth',
        'bonus',
        'overtime',
        'deductions',
        'gross_pay',
        'net_pay',
        'status',
        'total_late_hours',
        'total_undertime_hours',
        'payment_date',
        'drd',
        'special_holiday',
        'late_deduction',
        'rate',
        'earnings',
        'remarks',
        'rate_adjustment',
        'days_adjustment',
        'earnings_adjustment'
    ];

    public function othersForPayroll()
    {
        return $this->hasMany(OthersForPayroll::class, 'payroll_id');
    }

    public function trxLoanDeductions()
    {
        return $this->hasMany(TRXloandeductions::class, 'payroll_id');
    }
    public function trxConstantDeductions()
    {
        return $this->hasMany(ConstantDeduction::class, 'payroll_id');
    }



    public function batchCode()
    {
        return $this->belongsTo(Batchcode::class, 'code_id');
    }

    public function client()
    {
        return $this->belongsTo(Department::class, 'department_id');
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }


    // Relationship with Benefits
    public function benefits()
    {
        return $this->hasMany(Benefits::class, 'payroll_id');
    }
    public function billingAdjustments()
    {
        return $this->hasMany(BillingAdjustment::class, 'payroll_id'); // Ensure this is correct
    }
    public function loans()
    {
        return $this->hasMany(Loan::class, 'payroll_id'); // Ensure this is correct
    }
    // Method to get the billing ID from the first billing adjustment
    public function getBillingId()
    {
        return $this->billingAdjustments()->first()?->billing_id; // Access billing_id through billing adjustments
    }
}
