<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Requisition extends Model
{
    use HasFactory;

    protected $table = 'requisitions';


    protected $fillable = [
        'client_id',
        'department_id',
        'store_id',
        'status',
        'designation',
        'date',
        'job_title',
        'vacant_no',
        'rec_type',
        'budget_salary',
        'filled_date',
        'project_name',
        'replacement',
        'reasons',
        'gender',
        'vacant_form',

    ];

    // Define relationships

    // Relationship with the Client model
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    public function store()
    {
        return $this->belongsTo(Stores::class, 'store_id');
    }

    // Relationship with the Department model
    public function department()
    {
        return $this->belongsTo(Department::class);
    }
    public function mrfapplicant()
    {
        return $this->hasMany(MrfApplicant::class, 'requisition_id');
    }
}
