<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SettingForBilling extends Model
{
    use HasFactory;

    protected $table = 'settingforbilling';

    protected $fillable = [
        'client_id',
        'regular_column',
        'drd_column',
        'lh_column',
        'sh_column',
        'ot_column',
        'gross_pay',
        'thirtheen_month',
        'benefits',
    ];


    public function client()
    {
        return $this->belongsTo(Client::class);
    }
}
