<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TRXloandeductions extends Model
{
    use HasFactory;

    // Define the table associated with this model
    protected $table = 'loandeductions';

    // Define the attributes that are mass assignable
    protected $fillable = [
        'trx_loans_id',
        'payroll_id',
        'Amount',
        'amount_ad',
    ];

    // Relationships
    public function payroll()
    {
        return $this->belongsTo(Payroll::class, 'payroll_id');
    }

    public function trxLoan()
    {
        return $this->belongsTo(TrxLoan::class, 'trx_loans_id');
    }
}
