<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrxConstant extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'group_code_id',
        'trx_name',
        '1st',
        '2st',
        'dr',
        'status',
        'employee',
        'employer',
        'ec',
        'description',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
    public function trx_code()
    {
        return $this->belongsTo(TrxCode::class);
    }
}
