<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrxLoan extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'group_code_id',
        'trx_name',
        '1st',
        '2st',
        'seq',
        'status',
        'date',
        'reference',
        'total_amount',
        'installment',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class, 'employee_id');
    }

    public function trx_code()
    {
        return $this->belongsTo(TrxCode::class);
    }
}
