import './bootstrap';
import Echo from 'laravel-echo';
import Pusher from 'pusher-js';

window.Pusher = Pusher;

window.Echo = new Echo({
    broadcaster: 'pusher',
    key: import.meta.env.VITE_PUSHER_APP_KEY ?? 'local',
    cluster: import.meta.env.VITE_PUSHER_APP_CLUSTER ?? 'mt1',
    wsHost: import.meta.env.VITE_PUSHER_HOST ?? window.location.hostname,
    wsPort: import.meta.env.VITE_PUSHER_PORT ?? 6001,
    wssPort: import.meta.env.VITE_PUSHER_PORT ?? 6001,
    forceTLS: false,
    encrypted: false,
    disableStats: true,
    enabledTransports: ['ws', 'wss'],
});

// ✅ General function to listen for attendance events and reload any table
function setupRealtimeAttendance(tableSelector = '#agencyTable') {
    window.Echo.channel('attendance')
        .listen('.AttendanceUpdated', (e) => {
            console.log("📡 Real-time update:", e);
            const table = $(tableSelector).DataTable();
            if (table) {
                table.ajax.reload(null, false);
            } else {
                console.warn(`No DataTable found for selector: ${tableSelector}`);
            }
        });
}

// ✅ Example usage: call this wherever appropriate
setupRealtimeAttendance(); // default #agencyTable

// ✅ If you're on another page:
setupRealtimeAttendance('#projectTable'); // or any other table ID
