@extends('layouts.sidebar')

@section('title', 'Clients')
@section('content')
    @if (in_array('Manage Agency', $privileges))
        <div class="mx-auto">
            <div class="relative flex flex-col items-end justify-end mr-10 text-center">
                <div>
                    <button type="button"
                        class="inline-flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-blue-500 border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                        id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                        Menu
                        <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd"
                                d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                                clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                        role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                        id="dropdown-menu">
                        <div class="py-1" role="none">
                            <div class="flex flex-col items-center justify-center ">
                                <button id="showemployee"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Company
                                </button>
                                <button id="showbilling"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



            <div class="grid grid-cols-1 lg:grid-cols-6">
                <div class="w-full mb-3 bg-white border border-gray-200  shadow-md rounded-xl">
                    <p class="h-10 p-2 rounded-md text-md font-bold text-white  bg-[#1d1d1d]">Agency Profile</p>
                    <div class="p-4 text-xs overflow-auto">
                        <table class="w-full border border-collapse border-gray-300 table-auto">
                            <tbody>
                                <tr class="border-b border-gray-200">
                                    <td class="px-4 py-2 font-semibold">Logo</td>
                                    <td class="px-4 py-2 text-red-600"><img src="{{ asset($agency->contact_person) }}"
                                            width="50" height="50"></td>
                                </tr>
                                <tr class="border-b border-gray-200">
                                    <td class="px-4 py-2 font-semibold">Name:</td>
                                    <td class="px-4 py-2 text-red-600">{{ $agency->name }}</td>
                                </tr>
                                <tr>
                                    <td class="px-4 py-2 font-semibold">Address:</td>
                                    <td class="px-4 py-2 text-red-600">{{ $agency->address }}</td>
                                </tr>
                                <tr class="border-b border-gray-200">
                                    <td class="px-4 py-2 font-semibold">Contact Phone:</td>
                                    <td class="px-4 py-2 text-red-600">{{ $agency->contact_phone }}</td>
                                </tr>


                            </tbody>
                        </table>
                    </div>

                </div>
                <div class="md:col-span-5">
                    <div class="w-full p-4 overflow-auto rounded lg:w-full" id="employeeshow">
                        <h2 class="mb-6 font-bold text-md">Company List</h2>
                        <table id="company-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                            <thead>
                                <tr class="text-sm leading-normal  text-white  bg-[#1d1d1d]">
                                    <th class="px-6 py-1">ID</th>
                                    <th class="px-6 py-1">Name</th>
                                    <th class="px-6 py-1">Address</th>
                                    <th class="px-6 py-1">Contact Number</th>

                                    <th class="px-6 py-1">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-sm font-light text-center text-gray-600">
                                <!-- Data will be populated here by DataTables -->
                            </tbody>
                        </table>
                    </div>

                    <div id="billingshow"
                        class="hidden w-full p-4 bg-white border border-gray-200 rounded shadow-md lg:w-full">
                        <h2 class="mb-6 text-2xl font-bold">Billing List</h2>
                        <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                            <thead>
                                <tr class="text-sm leading-normal text-white uppercase bg-black">
                                    <th class="px-6 py-3">ID</th>
                                    <th class="px-6 py-3">Business Name</th>
                                    <th class="px-6 py-3">Owner Name</th>
                                    <th class="px-6 py-3">Address</th>
                                    <th class="px-6 py-3">Contact Number</th>
                                    <th class="px-6 py-3">Email</th>
                                    <th class="px-6 py-3">Amount Due</th>
                                    <th class="px-6 py-3">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-sm font-light text-center text-gray-600">
                                <!-- Example row (you can dynamically generate these) -->
                                <tr>
                                    <td class="px-6 py-4 border">1</td>
                                    <td class="px-6 py-4 border">Example Business</td>
                                    <td class="px-6 py-4 border">John Doe</td>
                                    <td class="px-6 py-4 border">123 Example St.</td>
                                    <td class="px-6 py-4 border">123-456-7890</td>
                                    <td class="px-6 py-4 border">email@example.com</td>
                                    <td class="px-6 py-4 border">$100.00</td> <!-- Amount Due Column -->
                                    <td class="px-6 py-4 border">
                                        <button class="text-blue-500 hover:underline">Edit</button>
                                        <button class="text-red-500 hover:underline">Delete</button>
                                    </td>
                                </tr>
                                <!-- Add more rows as needed -->
                            </tbody>
                        </table>
                    </div>
                </div>



            </div>


        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const showemployee = document.getElementById('showemployee');
                const showbilling = document.getElementById('showbilling');

                const employeeshow = document.getElementById('employeeshow');
                const billingshow = document.getElementById('billingshow');


                showemployee.addEventListener('click', function() {
                    employeeshow.classList.remove('hidden');
                    billingshow.classList.add('hidden');
                });

                // Show Billing Section button click
                showbilling.addEventListener('click', function() {
                    employeeshow.classList.add('hidden');
                    billingshow.classList.remove('hidden');
                });

                // Dropdown toggle
                document.getElementById('menu-button').addEventListener('click', function() {
                    const menu = document.getElementById('dropdown-menu');
                    menu.classList.toggle('hidden');
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                var clientId = {{ $agency->id }}; // Assuming you have a $client variable available

                var employedTable = $('#company-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('agency.profile', ['id' => ':id']) }}".replace(':id',
                            clientId),
                        data: function(d) {

                            d.agency_id = clientId;
                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'business_name',
                            name: 'business_name'
                        },
                        {
                            data: 'address',
                            name: 'address'
                        },
                        {
                            data: 'contact_number',
                            name: 'contact_number'
                        },

                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ]
                });
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
