@extends('layouts.sidebar')
@section('title', 'Agency')
@section('content')
    @if (in_array('Manage Agency', $privileges))
        @include('Admin.Agency.modal')
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 text-xl font-bold">Agencies</h1>
            @if (in_array('Create Agency', $privileges))
                <button type="button" onclick="openModal('agencymodal')"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700">
                    Add Agency
                </button>
            @endif
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class=" overflow-auto p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <table id="agencyTable" class="border border-collapse border-gray-200 rounded md:min-w-full ">
                <thead>
                    <tr class="text-xs leading-normal  text-white   bg-[#1d1d1d]">
                        <th>Logo</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Address</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">

                </tbody>
            </table>
        </div>

        <script>
            $(document).ready(function() {
                $('#agencyTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('agencies.index') }}",
                    columns: [{
                            data: 'image',
                            name: 'image'
                        }, {
                            data: 'name',
                            name: 'name'
                        },


                        {
                            data: 'contact_phone',
                            name: 'contact_phone'
                        },
                        {
                            data: 'address',
                            name: 'address'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ]
                });
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
