<!DOCTYPE html>
<html>

<head>
    <title>Employee Attendance Report</title>
    <style>
        /* General Styles */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 0;
            padding: 20px;
        }

        .header {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            color: #0a3d62;
            margin-bottom: 5px;
        }

        .sub-header {
            text-align: center;
            font-size: 14px;
            color: #2d3436;
            margin-bottom: 20px;
        }

        .info {
            margin-bottom: 20px;
        }

        .info strong {
            color: #0a3d62;
        }

        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }

        th,
        td {
            border: 1px solid #b2bec3;
            padding: 8px;
            text-align: center;
            vertical-align: middle;
        }

        th {
            background-color: #0984e3;
            color: #fff;
            font-weight: 600;
        }

        tr:nth-child(even) td {
            background-color: #f1f2f6;
        }

        tr:hover td {
            background-color: #dfe6e9;
        }

        tfoot th {
            background-color: #636e72;
            color: #fff;
            font-size: 13px;
        }

        /* Selfie Styles */
        img.selfie {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 1px solid #b2bec3;
        }

        /* Footer */
        .footer {
            margin-top: 30px;
            font-size: 11px;
            text-align: center;
            color: #636e72;
        }
    </style>
</head>

<body>
    <div class="header">EMPLOYEE ATTENDANCE REPORT</div>
    <div class="sub-header">Comprehensive Daily Time Record</div>

    <div class="info">
        <strong>Employee ID:</strong> {{ $employee->employee_id ?? '' }} &nbsp;&nbsp;
        <strong>Name:</strong> {{ $employee->employee->last_name ?? '' }} &nbsp;&nbsp;
        <strong>Department:</strong> {{ $employee->department->department_name ?? '' }}<br>
        @if ($startDate && $endDate)
            <strong>Date Range:</strong> {{ $startDate }} to {{ $endDate }}
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th>Selfie</th>
                <th>Date</th>
                <th>Time In</th>
                <th>Break Out</th>
                <th>Break In</th>
                <th>Time Out</th>
                <th>OT In</th>
                <th>OT Out</th>
                <th>Hours Worked</th>
            </tr>
        </thead>
        <tbody>
            @php $totalMinutes = 0; @endphp
            @foreach ($attendances as $att)
                <tr>
                    @php
                        $img = null;
                        if ($att->selfie) {
                            try {
                                $imgData = Storage::disk('spaces')->get($att->selfie);
                                $img = 'data:image/png;base64,' . base64_encode($imgData);
                            } catch (\Exception $e) {
                                $img = null;
                            }
                        }
                    @endphp
                    <td>
                        @if ($img)
                            <img src="{{ $img }}" class="selfie">
                        @else
                            <span style="color:#b2bec3;">No selfie</span>
                        @endif
                    </td>
                    <td>{{ $att->date }}</td>
                    <td>{{ $att->time_in }}</td>
                    <td>{{ $att->break_out }}</td>
                    <td>{{ $att->break_in }}</td>
                    <td>{{ $att->time_out }}</td>
                    <td>{{ $att->ot_in }}</td>
                    <td>{{ $att->ot_out }}</td>
                    <td>{{ $att->hours_worked }}</td>
                </tr>
                @php
                    preg_match('/(\d+)\s*hrs\s*(\d*)\s*mins?/', $att->hours_worked, $matches);
                    $hours = $matches[1] ?? 0;
                    $minutes = $matches[2] ?? 0;
                    $totalMinutes += $hours * 60 + $minutes;
                @endphp
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="8" style="text-align:right">Total Hours Worked:</th>
                <th>
                    @php
                        $totalHours = floor($totalMinutes / 60);
                        $remainingMinutes = $totalMinutes % 60;
                        echo $totalHours . ' hrs ' . $remainingMinutes . ' mins';
                    @endphp
                </th>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        Generated on {{ \Carbon\Carbon::now()->format('F j, Y, g:i A') }}
    </div>
</body>

</html>
